package cn.com.duiba.thirdpartyvnew.dto.yaduo;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * logistics_sync_ack.php（物流同步回写）入参DTO
 *
 * @author wgh
 */
@Data
public class LogisticsSyncAckReqDto implements Serializable {

    private static final long serialVersionUID = 6116611701281785752L;

    /**
     * 物流同步状态回传列表
     */
    @JSONField(name = "logistics_list")
    private List<LogisticsListItem> logisticsList;

    @Data
    public static class LogisticsListItem implements Serializable {

        private static final long serialVersionUID = 461778239766950536L;

        /**
         * 回写的记录id
         */
        @JSONField(name = "rec_id")
        private Integer recId;

        /**
         * 回写状态: 0成功 1失败
         */
        @JSONField(name = "status")
        private Integer status;
    }
}
