package cn.com.duiba.thirdpartyvnew.api.lyf;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.thirdpartyvnew.dto.lyf.reponse.AreasInfoResponse;
import cn.com.duiba.thirdpartyvnew.dto.lyf.reponse.SubAreasInfoResponse;
import cn.com.duiba.thirdpartyvnew.dto.lyf.reponse.UserAdressResponse;
import cn.com.duiba.thirdpartyvnew.dto.lyf.request.UpdateUserAddressRequest;

import java.util.List;

/**
 * 来伊份接口定制
 * @author lyj
 */
@AdvancedFeignClient
public interface RemoteLaiYiFenService {


    /**
     * 获取所有地域信息
     *
     * @return 返回所有的地域信息
     * @throws Exception 所有异常向上抛出
     */
    AreasInfoResponse getAllRegionInfo() throws Exception;

    /**
     * 通过父地域ID获取子地域信息
     *
     * @param parentId 父地域ID
     * @return 返回子地域信息
     * @throws Exception 所有异常向上抛出
     */
    List<SubAreasInfoResponse> getChildRegionInfo(Integer parentId) throws Exception;

    /**
     * 获取收获地址列表
     *
     * @param userId   用户ID
     * @param pageSize 每页显示数量
     * @param pageNum  页码
     * @return 返回收获地址列表
     * @throws Exception 所有异常向上抛出
     */
    List<UserAdressResponse> getUserAddressList(String userId, int pageSize, int pageNum) throws Exception;

    /**
     * 新增收货地址
     *
     * @param request 新增收货地址请求对象
     * @throws Exception 所有异常向上抛出
     */
    void addUserAddress(UpdateUserAddressRequest request) throws Exception;


    /**
     * 修改收货地址
     *
     * @param request 修改收货地址请求对象
     * @throws Exception 所有异常向上抛出
     */
    void updateUserAddress(UpdateUserAddressRequest request) throws Exception;

    /**
     * 删除收货地址
     *
     * @param userId 用户ID
     * @param id     收货地址ID
     * @throws Exception 所有异常向上抛出
     */
    void deleteUserAddress(String userId, String id) throws Exception;


}
