package cn.com.duiba.thirdpartyvnew.dto.lshm.response;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class LshmShopQueryResponseData implements Serializable {
    /**
     * 总数量
     */
    private Long total;
    /**
     * 店铺列表
     */
    private List<Shop> data;

    @Data
    public static class Shop{
        /**
         * 门店id
         */
        private String id;
        /**
         * 门店名称
         */
        private String name;
        /**
         * 门店经纬度
         */
        private GeoLocation geoLocation;
        /**
         * 距离，单位公里
         */
        private String distance;
        /**
         * 门店地址
         */
        private String address;
        /**
         * 门店状态
         */
        private String storeStatus;
        /**
         * 门店编码
         */
        private String storeCode;
    }

    @Data
    public static class GeoLocation {
        private String lon;
        private String lat;
    }
}
