package cn.com.duiba.thirdpartyvnew.api.dcjj;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.thirdpartyvnew.dto.dcjj.DcjjDrawCallBackParam;
import cn.com.duiba.thirdpartyvnew.dto.dcjj.DcjjPreCheckData;
import cn.com.duiba.thirdpartyvnew.dto.dcjj.DcjjPreCheckParam;
import cn.com.duiba.thirdpartyvnew.dto.dcjj.DcjjResult;

/**
 * 大成基金本地化接口
 */
@AdvancedFeignClient
public interface RemoteDcjjService {

    /**
     * 校验查询
     * @param preCheckParam 请求参数
     * @return 失败 success 返回false
     */
    DcjjResult<String> checkLimitUrl(DcjjPreCheckParam preCheckParam);

    /**
     * 校验扣库存下单
     * @param preCheckParam 请求参数
     * @return 校验true 成功 校验失败false
     */
    DcjjResult<DcjjPreCheckData> preCheck(DcjjPreCheckParam preCheckParam);

    /**
     * 领取回调
     * @param callBackParam 回调参数
     */
    DcjjResult<String> drawCallBack(DcjjDrawCallBackParam callBackParam);
}
