package cn.com.duiba.thirdpartyvnew.dto.wanda.request;

import lombok.Data;

import java.io.Serializable;

/**
 * 万达认证token请求DTO
 *
 * @author zhangdaqing
 * @date 2025/7/10
 */
@Data
public class WandaAuthTokenRequest implements Serializable {
    
    private static final long serialVersionUID = 1L;
    
    /**
     * 帐号
     */
    private String account;
    
    /**
     * 创建认证token请求
     * 
     * @param account 帐号
     * @return WandaAuthTokenRequest
     */
    public static WandaAuthTokenRequest create(String account) {
        WandaAuthTokenRequest request = new WandaAuthTokenRequest();
        request.setAccount(account);
        return request;
    }
} 