package cn.com.duiba.thirdpartyvnew.api.wanda;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.thirdpartyvnew.dto.wanda.request.WandaCouponVerificationRequest;
import cn.com.duiba.thirdpartyvnew.dto.wanda.request.WandaCouponCancelRequest;
import cn.com.duiba.thirdpartyvnew.dto.wanda.request.WandaCouponQueryRequest;
import cn.com.duiba.thirdpartyvnew.dto.wanda.response.WandaCouponDetail;

import java.util.List;

/**
 * 万达兑换服务远程接口
 *
 * @author zhangdaqing
 * @Description 万达第三方服务远程接口，用于对外提供服务
 * @date 2025/7/10 11:52
 */
@AdvancedFeignClient
public interface RemoteWandaExchangeService {
    
    /**
     * 获取万达认证Token
     * 
     * @return 访问令牌 accessToken
     */
    String getAuthToken();
    
    /**
     * 万达优惠券核销
     * 
     * @param request 优惠券核销请求参数
     * @return 核销结果，true：成功，false：失败
     */
    boolean verifyCoupon(WandaCouponVerificationRequest request);
    
    /**
     * 万达优惠券反核销
     * 
     * @param request 优惠券反核销请求参数
     * @return 反核销结果，true：成功，false：失败
     */
    boolean cancelCoupon(WandaCouponCancelRequest request);
    
    /**
     * 获取万达会员优惠券
     * 
     * @param request 获取会员优惠券请求参数
     * @return 会员优惠券列表
     */
    List<WandaCouponDetail> queryCoupons(WandaCouponQueryRequest request);
}
