package cn.com.duiba.thirdpartyvnew.dto.logistics;

import java.io.Serializable;

/**
 * 快递100订阅请求参数
 * <a href="https://www.kuaidi100.com/openapi/api_subscribe.shtml">快递100订阅接口文档</a>
 *
 */
public class SubscribeRequestParam implements Serializable {

    private static final long serialVersionUID = -1455608582571066669L;
    /**
     * 订阅的快递公司的编码，一律用小写字母
     */
    private String company;

    /**
     * 订阅的快递单号，单号的最大长度是32个字符
     */
    private String number;

    /**
     * 回调接口的地址，默认仅支持http，如需兼容https请联系快递100技术人员处理
     */
    private String callbackUrl;

    /**
     * 手机号
     * 收件人或寄件人的手机号或固话（顺丰单号必填，也可以填写后四位，如果是固话，请不要上传分机号）
     */
    private String phone;

    /**
     * 签名盐值(不可为空，空则回调不签名，数据层级变化)
     */
    private String salt;

    public String getSalt() {
        return salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getCompany() {
        return company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getCallbackUrl() {
        return callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }
}
