package cn.com.duiba.thirdpartyvnew.dto.wanda.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
public class WandaSubmitInvoiceRequest extends WandaTaxBaseRequest {

    /**
     * 订单信息
     */
    private Order order;


    /**
     * 订单信息
     */
    @Data
    public static class Order implements Serializable {
        /**
         * 购方名称 企业名称/个人
         */
        private String buyerName;

        /**
         * 购方税号（企业要填，个人可为空；数电
         * 专票、二手车销售统一发票时必填）
         */
        private String buyerTaxNum;

        /**
         * 销方税号（使用沙箱环境请求时消息体参
         * 数salerTaxNum和消息头参数userTax
         * 填写339902999999789113）
         */
        private String salerTaxNum;

        /**
         * 订单号
         */
        private String orderNo;

        /**
         * 订单时间 格式为：yyyy-MM-dd HH:mm:ss
         */
        private String invoiceDate;

        /**
         * 推送模式 -1,不推送;0,邮箱;1,手机（默认）;2,邮箱、手机
         */
        private String pushMode;

        /**
         * 购方手机（pushMode为1或2时，此项为必填，同时受企业资质是否必填控制）
         */
        private String buyerPhone;

        /**
         * 推送邮箱（pushMode为0或2时，此项为必填，同时受企业资质是否必填控制）
         */
        private String email;

        /**
         * 开票类型：1:蓝票;2:红票 （数电票冲红请对接数电快捷冲红接口）
         * 目前都是蓝票
         */
        private String invoiceType;

        /**
         * 发票种类：pc 电子发票
         */
        private String invoiceLine;

        /**
         * 回传发票信息地址（开票完成、开票失败）
         */
        private String callBackUrl;

        /**
         * 发票明细
         */
        private List<InvoiceDetail> invoiceDetail;
    }

    /**
     * 发票明细
     */
    @Data
    public static class InvoiceDetail implements Serializable{
        /**
         * 商品名称
         */
        private String goodsName;
        /**
         * 商品编码（商品税收分类编码开发者自行
         * 填写）
         */
        private String goodsCode;

        /**
         * 单价含税标志 0:无税;1:含税
         */
        private String withTaxFlag;

        /**
         * 单价（精确到小数点后8位），当单价(pri
         * ce)为空时，数量(num)也必须为空；(pric
         * e)为空时，含税金额(taxIncludedAmou
         * nt)、不含税金额(taxExcludedAmount)
         * 、税额(tax)都不能为空
         */
        private String price;

        /**
         * 数量（精确到小数点后8位，开具红票时数
         * 量为负数）
         */
        private String num;

        /**
         * 含税金额（精确到小数点后2位），[不含
         * 税金额] + [税额] = [含税金额]，红票为负
         * 。不含税金额、税额、含税金额任何一个
         */
        private String taxIncludedAmount;

        /**
         * 税率，注：1、纸票清单红票存在为null的
         * 情况；2、二手车发票税率为null或者0
         */
        private String taxRate;

    }
}
