package cn.com.duiba.thirdpartyvnew.api.wanda;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.thirdpartyvnew.dto.wanda.request.WandaQueryInvoiceRequest;
import cn.com.duiba.thirdpartyvnew.dto.wanda.request.WandaRetryInvoiceRequest;
import cn.com.duiba.thirdpartyvnew.dto.wanda.request.WandaSubmitInvoiceRequest;
import cn.com.duiba.thirdpartyvnew.dto.wanda.response.WandaQueryInvoiceResponseData;
import cn.com.duiba.thirdpartyvnew.dto.wanda.response.WandaSubmitInvoiceResponseData;
import cn.com.duiba.thirdpartyvnew.dto.wanda.response.WandaTaxBaseResponse;

import java.util.List;

@AdvancedFeignClient
public interface RemoteWanTaxService {
    /**
     * 提交开票
     */
    WandaTaxBaseResponse<WandaSubmitInvoiceResponseData> submitInvoice(WandaSubmitInvoiceRequest request);

    /**
     * 重试开票
     */
    WandaTaxBaseResponse<String> retryInvoice(WandaRetryInvoiceRequest request);

    /**
     * 获取开票信息
     */
    WandaTaxBaseResponse<List<WandaQueryInvoiceResponseData>> getInvoiceInfo(WandaQueryInvoiceRequest request);


}
