package cn.com.duiba.thirdpartyvnew.dto.jincheng;

import cn.com.duiba.thirdpartyvnew.dto.jincheng.top.BaseReqDto;
import cn.com.duiba.thirdpartyvnew.dto.jincheng.top.BaseReqInterface;

import java.io.Serializable;

/**
 * 金城银行-兑吧订单推送接口-请求入参
 *
 * @author songp
 * @date 2024/5/22 7:37 下午
 */
public class PushOrderReqDto implements BaseReqInterface, Serializable {


    /**
     * appkey
     */
    private String appKey;

//    private String timestamp;

//    private String sign;

    /**
     * uid
     */
    private String uid;

    /**
     * 兑吧订单号
     */
    private String orderNum;

    /**
     * 开发者订单号（扣积分时返回）
     */
    private String developBizId;

    /**
     * 下单时间，单位：时间戳，下单时间毫秒值
     */
    private String createTime;

    /**
     * 订单完结时间，单位：时间戳，订单完结时间毫秒值
     */
    private String finishTime;

    /**
     * 总积分
     */
    private String totalCredits;

    /**
     * 用户支付总金额，单位：元
     */
    private String consumerPayPrice;

    /**
     * 订单来源，普兑，刮刮乐大转盘等
     */
    private String source;

    /**
     * 订单状态 waitAudit待审核，waitSend待发货，afterSend已发货待售后，success成功，fail失败
     */
    private String orderStatus;

    /**
     * 失败原因
     */
    private String errorMsg;

    /**
     * 订单类型：商品类型object（实物），coupon(优惠券，卡密也是优惠券类型)，
     * virtual（虚拟商品）,alipay（支付宝），phonebill（话费），qb
     */
    private String type;

    /**
     * 运费，单位：元
     */
    private String expressPrice;

    /**
     * 直充账号
     */
    private String account;

    /**
     * 订单信息 item 类型: string
     */
    private String orderItemList;

    /**
     * 收货地址信息（实物商品必填）
     */
    private String receiveAddrInfo;

    @Override
    public BaseReqDto getCommonParam() {
        return null;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDevelopBizId() {
        return developBizId;
    }

    public void setDevelopBizId(String developBizId) {
        this.developBizId = developBizId;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getFinishTime() {
        return finishTime;
    }

    public void setFinishTime(String finishTime) {
        this.finishTime = finishTime;
    }

    public String getTotalCredits() {
        return totalCredits;
    }

    public void setTotalCredits(String totalCredits) {
        this.totalCredits = totalCredits;
    }

    public String getConsumerPayPrice() {
        return consumerPayPrice;
    }

    public void setConsumerPayPrice(String consumerPayPrice) {
        this.consumerPayPrice = consumerPayPrice;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public String getExpressPrice() {
        return expressPrice;
    }

    public void setExpressPrice(String expressPrice) {
        this.expressPrice = expressPrice;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getOrderItemList() {
        return orderItemList;
    }

    public void setOrderItemList(String orderItemList) {
        this.orderItemList = orderItemList;
    }

    public String getReceiveAddrInfo() {
        return receiveAddrInfo;
    }

    public void setReceiveAddrInfo(String receiveAddrInfo) {
        this.receiveAddrInfo = receiveAddrInfo;
    }
}
