package cn.com.duiba.thirdpartyvnew.dto.lshm.enums;

/**
 * 联商惠民优惠券状态枚举
 */
public enum LshmCouponStatus {
    /**
     * 未使用
     */
    NOTUSE("NOTUSE", "未使用"),

    /**
     * 已使用
     */
    USE("USE", "已使用"),

    /**
     * 已过期
     */
    INVALID("INVALID", "已过期"),

    /**
     * 已冻结
     */
    FREEZE("FREEZE", "已冻结"),

    /**
     * 部分使用
     */
    PART_USE("PART_USE", "部分使用"),

    /**
     * 已作废
     */
    DISABLE("DISABLE", "已作废"),

    /**
     * 未生效
     */
    INEFFECTIVE("INEFFECTIVE", "未生效");

    /**
     * 代码
     */
    private final String code;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 构造函数
     *
     * @param code 代码
     * @param desc 描述
     */
    LshmCouponStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 获取代码
     *
     * @return 代码
     */
    public String getCode() {
        return code;
    }

    /**
     * 获取描述
     *
     * @return 描述信息
     */
    public String getDesc() {
        return desc;
    }

    /**
     * 根据代码获取枚举值
     *
     * @param code 代码
     * @return 对应的枚举值，如果不存在则返回null
     */
    public static LshmCouponStatus getByCode(String code) {
        if (code == null) {
            return null;
        }

        for (LshmCouponStatus status : values()) {
            if (status.getCode().equals(code)) {
                return status;
            }
        }
        return null;
    }
}