package cn.com.duiba.thirdpartyvnew.api.jhj;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.thirdpartyvnew.dto.jhj.request.JhjBaseRequest;
import cn.com.duiba.thirdpartyvnew.dto.jhj.request.JhjCreateOrderRequest;
import cn.com.duiba.thirdpartyvnew.dto.jhj.request.JhjExpressRequest;
import cn.com.duiba.thirdpartyvnew.dto.jhj.request.JhjOrdersRecordRequest;
import cn.com.duiba.thirdpartyvnew.dto.jhj.response.JhjAddressResponseData;
import cn.com.duiba.thirdpartyvnew.dto.jhj.response.JhjCreateOrderResponseData;
import cn.com.duiba.thirdpartyvnew.dto.jhj.response.JhjOrderDetailVO;
import cn.com.duiba.thirdpartyvnew.dto.jhj.response.JhjOrderVO;
import cn.com.duiba.thirdpartyvnew.dto.jhj.response.JhjPageResponseVO;

import java.util.List;

/**
 * @author zhangdaqing
 * @Description
 * @date 2025/5/14 19:34
 */
@AdvancedFeignClient
public interface RemoteJhjService {

    Long queryPoints(JhjBaseRequest request);

    /**
     * 保存收货地址
     *
     * @param request
     */
    Boolean insertAddress(JhjExpressRequest request);

    /**
     * 收货地址列表
     *
     * @return {@link List}<{@link JhjAddressResponseData}>
     */
    List<JhjAddressResponseData> listAddress(JhjBaseRequest request);


    /**
     * 修改地址
     *
     * @param request
     * @return {@link Boolean}
     */
    Boolean updateAddress(JhjExpressRequest request);


    /**
     * 删除地址
     *
     * @param request
     * @return {@link Boolean}
     */
    Boolean deleteAddress(JhjExpressRequest request);


    /**
     * 创建订单
     *
     * @param request
     * @return {@link JhjCreateOrderResponseData}
     */
    JhjCreateOrderResponseData createOrder(JhjCreateOrderRequest request);

    /**
     * 查询实物中奖记录
     *
     * @param request 请求
     * @return 响应
     */
    JhjPageResponseVO<JhjOrderVO> ordersRecord(JhjOrdersRecordRequest request);
}
