package cn.com.duiba.thirdpartyvnew.dto.wdt;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.util.List;

/**
 * 旺店通旗舰版原始订单推送返回结果
 *
 * @author cgq
 * @date 2025-01-27
 */
@Data
public class SalesRawTradePushSelfResult {

    /**
     * 更新订单数
     */
    @JSONField(name = "chg_count")
    private Integer chgCount;

    /**
     * 新增订单数
     */
    @JSONField(name = "new_count")
    private Integer newCount;

    /**
     * 错误信息
     */
    @JSONField(name = "error_list")
    private List<ErrorInfo> errorList;

    @Data
    public static class ErrorInfo {

        /**
         * 单号
         */
        private String no;

        /**
         * 错误信息
         */
        private String error;
    }
}
