package cn.com.duiba.thirdparty.api.boc;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.thirdparty.dto.boc.IdentityDataDto;
import cn.com.duiba.thirdparty.dto.boc.LabelDataReqParam;
import cn.com.duiba.thirdparty.dto.boc.PublicDataReqParam;
import cn.com.duiba.thirdparty.dto.boc.UnionNoReqParam;
import com.alibaba.fastjson.JSONObject;

import java.io.IOException;
import java.util.List;

/**
 * 福建中行上送接口
 * @author chenzhenxing
 * @date 2021/11/10 5:14 下午
 */
@AdvancedFeignClient
public interface RemoteFjBocService {

    JSONObject duibaDataUpload(List<IdentityDataDto> dataDtoList) throws IOException;
    /**
     * 公众号数据上送接口
     * @param publicDataReqParam
     * @return
     * @throws IOException
     */
    JSONObject wxDataExport(PublicDataReqParam publicDataReqParam) throws IOException;

    /**
     * 外部第三方标签数据上送接口
     * @param dataRerParam
     * @return
     * @throws IOException
     */
    JSONObject labelDataExport(LabelDataReqParam dataRerParam) throws IOException;

    /**
     * union_no查询接口
     * @param reqParam
     * @return
     * @throws IOException
     */
    JSONObject getUnionNo(UnionNoReqParam reqParam) throws IOException;

    String verifyUser(String openId);
}
