package cn.com.duiba.thirdparty.api;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.thirdparty.dto.VirtualCurrencyMessage;

/**
 * @program: thirdparty-all
 * @description: 扣虚拟货币服务
 * @author: Simba
 * @create: 2019-03-15 10:13
 **/
@AdvancedFeignClient
public interface RemoteVirtualCurrencyService {

    /**
     * 扣虚拟货币接口<br/>
     * 1.将扣虚拟货币请求丢到HTTP请求池中<br/>
     * 2.返回Boolean是否提交成功<br/>
     * 3.HTTP异步处理完后会把响应结果发送到 callbackTopic队列中<br/>
     * 4.业务方订阅callbackTopic队列进行后续流程<br/>
     *
     * @param request 扣虚拟货币请求参数
     * @param callbackTopic 扣虚拟货币回调topic
     * @param msgTag 标签，对消息进行再归类，可为null
     * @param msgKey 消息平台唯一键，用于在消息平台查找消息,可为null
     * @return boolean ture:提交成功   false:提交失败
     */
    void submitSubVirtualCurrency(VirtualCurrencyMessage request, String callbackTopic, String msgTag, String msgKey);
}

