package cn.com.duiba.thirdparty.api.hsbc;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.thirdparty.dto.hsbc.HsbcPointTask;
import cn.com.duiba.thirdparty.dto.hsbc.TaskStatusQuery;
import cn.com.duiba.thirdparty.dto.hsbc.TaskStatusRespData;
import cn.com.duiba.thirdparty.dto.hsbc.UserInfoDto;

import java.util.List;

/**
 * @author haojiahong
 * @date 2021-12-27
 */
@AdvancedFeignClient
public interface RemoteHsbcBankServcie {

    /**
     * 获取汇丰用户信息
     *
     * @param hsbcOpenId 汇丰小程序用户openId
     * @param hsbcAppId  汇丰小程序appId
     * @param duibaAppId 兑吧应用id
     * @return
     */
    UserInfoDto getUserInfo(String hsbcOpenId, String hsbcAppId, Long duibaAppId);

    /**
     * 查询汇丰任务列表
     *
     * @param duibaAppId 兑吧应用id
     * @return 任务数据列表
     */
    List<HsbcPointTask> queryTaskList(Long duibaAppId);


    /**
     * 查询任务状态接口
     *
     * @param queryParams 查询参数
     * @return 开发者接口返回数据
     */
    TaskStatusRespData doTaskStatusQuery(TaskStatusQuery queryParams);
}
