package cn.com.duiba.thirdparty.dto;

import java.io.Serializable;
import java.util.Map;

/**
 * HTTP请求消息DTO
 */
public class HttpRequestMessageDto implements Serializable {

	private static final long serialVersionUID = -5747305739689657358L;
	
	public static final String RETRY_CRECORD = "crecord"; // 兑换记录
	public static final String ORDER_STATUS_PUSH = "orderStatusPush"; // 订单同步
	public static final String RETRY_ADD_CREDITS = "addCredits"; // 加积分
	public static final String RETRY_SUB_VIRTUAL_CURRENCY = "subVirtualCurrency"; //提现虚拟货币
	public static final String RETRY_CONSUME_RESULT = "consumeResult"; //扣积分结果查询

	public static final String HTTP_GET = "get"; // get请求类型
	public static final String HTTP_POST = "post"; // post请求类型

	private String bizType; // 业务类型
	private String bizId; // 业务唯一编号
	private Long appId; // 应用ID
	private Boolean isResult; // 是否需要订阅HTTP响应信息 true：是 false: 否
	private Boolean isAllowRepeat;// 是否允许重复处理 true：是 false: 否
	private String httpType;// 请求类型
	private String httpUrl; // 请求URL
	private Map<String, String> httpParams; // 请求参数
	private Map<String, String> extendParams; // 扩展参数

	public String getBizType() {
		return bizType;
	}

	public void setBizType(String bizType) {
		this.bizType = bizType;
	}

	public String getBizId() {
		return bizId;
	}

	public void setBizId(String bizId) {
		this.bizId = bizId;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public Boolean getIsResult() {
		return isResult;
	}

	public void setIsResult(Boolean isResult) {
		this.isResult = isResult;
	}

	public Boolean getIsAllowRepeat() {
		return isAllowRepeat;
	}

	public void setIsAllowRepeat(Boolean isAllowRepeat) {
		this.isAllowRepeat = isAllowRepeat;
	}

	public String getHttpType() {
		return httpType;
	}

	public void setHttpType(String httpType) {
		this.httpType = httpType;
	}

	public String getHttpUrl() {
		return httpUrl;
	}

	public void setHttpUrl(String httpUrl) {
		this.httpUrl = httpUrl;
	}

	public Map<String, String> getHttpParams() {
		return httpParams;
	}

	public void setHttpParams(Map<String, String> httpParams) {
		this.httpParams = httpParams;
	}

	public Map<String, String> getExtendParams() {
		return extendParams;
	}

	public void setExtendParams(Map<String, String> extendParams) {
		this.extendParams = extendParams;
	}

}
