package cn.com.duiba.thirdparty.alarm;

import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

import java.io.IOException;

/**
 * 短信消息
 */
public class Message {

    private Message(){
        //do nothing
    }

    private static final String SEND_API = "http://yunpian.com/v1/sms/send.json";
    private static final String API_KEY = "dd66615d922f2519ff134c0df909e505";

    /**
     * 发送短信方法，请注意不能频繁调用。接口已经公布出去暂时不能用框架的httpClient
     * @param phone
     * @param content
     * @return
     * @throws Exception
     */
    public static String sned(String phone, String content) throws IOException {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(3000).setConnectionRequestTimeout(3000).setSocketTimeout(3000).build();
        CloseableHttpClient httpclient = HttpClients.custom().setDefaultRequestConfig(config).build();
        HttpPost httpPost = new HttpPost(SEND_API);
        httpPost.addHeader("Accept", "application/json; charset=utf-8");
        httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
        String textMsg = "mobile=" + phone + "&apikey=" + API_KEY + "&text=【兑吧科技】发生异常，内容是" + content;
        StringEntity se = new StringEntity(textMsg, "utf-8");
        httpPost.setEntity(se);

        try( CloseableHttpResponse response = httpclient.execute(httpPost)) {
            return EntityUtils.toString(response.getEntity(), "utf-8");
        }
    }

}
