package cn.com.duiba.thirdparty.api.hsbc;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.thirdparty.dto.hsbc.HsbcBehaviorTraceParam;
import cn.com.duiba.thirdparty.dto.hsbc.HsbcConfigDTO;
import cn.com.duiba.thirdparty.dto.hsbc.HsbcConsumerAmountDto;
import cn.com.duiba.thirdparty.dto.hsbc.HsbcNewsPageDto;
import cn.com.duiba.thirdparty.dto.hsbc.HsbcNewsPageParam;
import cn.com.duiba.thirdparty.dto.hsbc.HsbcPointTask;
import cn.com.duiba.thirdparty.dto.hsbc.HsbcPreWithdrawDto;
import cn.com.duiba.thirdparty.dto.hsbc.TaskCompleteQuery;
import cn.com.duiba.thirdparty.dto.hsbc.TaskCompleteRespData;
import cn.com.duiba.thirdparty.dto.hsbc.TaskStatusQuery;
import cn.com.duiba.thirdparty.dto.hsbc.TaskStatusRespData;
import cn.com.duiba.thirdparty.dto.hsbc.UserInfoDto;
import cn.com.duiba.thirdparty.dto.hsbc.param.HsbcInformHandleRedEnvelopeParam;
import cn.com.duiba.thirdparty.dto.hsbc.param.HsbcMatchPhoneParam;
import cn.com.duiba.thirdparty.dto.hsbc.param.HsbcPreWithdrawParam;
import cn.com.duiba.thirdparty.dto.hsbc.param.HsbcUserParam;

import java.util.List;

/**
 * @author haojiahong
 * @date 2021-12-27
 */
@AdvancedFeignClient
public interface RemoteHsbcBankServcie {

    /**
     * 获取汇丰用户信息
     *
     * @param hsbcOpenId 汇丰小程序用户openId
     * @param hsbcAppId  汇丰小程序appId
     * @param duibaAppId 兑吧应用id
     * @return
     */
    UserInfoDto getUserInfo(String hsbcOpenId, String hsbcAppId, Long duibaAppId);

    /**
     * 查询汇丰任务列表
     *
     * @param duibaAppId 兑吧应用id
     * @return 任务数据列表
     */
    List<HsbcPointTask> queryTaskList(Long duibaAppId);


    /**
     * 查询任务状态接口
     *
     * @param queryParams 查询参数
     * @return 开发者接口返回数据
     */
    TaskStatusRespData doTaskStatusQuery(TaskStatusQuery queryParams);


    /**
     * 得到汇丰银行配置
     *
     * @return {@link HsbcConfigDTO}
     */
    HsbcConfigDTO getHsbcConfig();

    /**
     * 查询资讯列表
     * @param pageParam
     * @param appId
     * @return
     */
    HsbcNewsPageDto getNewsByPage(HsbcNewsPageParam pageParam, Long appId);

    /**
     * 查询单个任务完成情况
     * @param query
     * @param appId
     * @return
     */
    TaskCompleteRespData doTaskCompleteQuery(TaskCompleteQuery query, Long appId);

    /**
     * 添加追踪行为操作记录日志
     */
    boolean addBehaviorTrace(HsbcBehaviorTraceParam param);

    /**
     * 获取用户余额、风险等级信息
     * @param hsbcUserParam
     * @return
     */
    HsbcConsumerAmountDto getUserAmountInfo(HsbcUserParam hsbcUserParam);

    /**
     * 红包预提现接口
     * @param hsbcPreWithdrawParam
     * @return
     */
    HsbcPreWithdrawDto preWithdrawRedEnvelope(HsbcPreWithdrawParam hsbcPreWithdrawParam);

    /**
     * 提现结果通知接口(重试逻辑类似通知，third去做)
     * @param hsbcInformHandleRedEnvelopeParam
     * @return
     */
    void informHandleRedEnvelopeResult(HsbcInformHandleRedEnvelopeParam hsbcInformHandleRedEnvelopeParam);

    /**
     * 手机号匹配校验
     * @param hsbcMatchPhoneParam
     * @return true:匹配
     */
    boolean matchPhone(HsbcMatchPhoneParam hsbcMatchPhoneParam);

    /**
     * 获取通用令牌
     *
     * @param appId 应用id
     * @return {@link String}
     */
    String getGeneralToken(Long appId);

    /**
     * 获取太阳码
     *
     * @param key   键
     * @param appId 应用id
     * @return {@link String}
     */
    String getSolarCode(String key,Long appId);


}
