package cn.com.duiba.thirdparty.enums.kww;

import java.util.Objects;

/**
 * @Author: fss
 * @Date: 2022/9/15 18
 * @Description:口味王超时类型
 */
public enum TimeoutTypeEnum {

    SUB_RESULT_TIMEOUT(1, "扣积分结果查询重试多次超时"),
    ADD_CREDITS_RETRY_TIMEOUT(2, "加积分重试多次超时");

    Integer type;
    String desc;

    public static TimeoutTypeEnum valueOfType(Integer type) {
        for (TimeoutTypeEnum obj : TimeoutTypeEnum.values()) {
            if (Objects.equals(obj.type, type)) {
                return obj;
            }
        }
        return null;
    }

    TimeoutTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
