package cn.com.duiba.thirdparty.mq.msg;

import java.io.Serializable;

/**
 * 加积分开发者响应信息
 * Created by xiaoxuda on 2018/6/10.
 */
public class AddCreditsDevMsg implements Serializable {
    private static final long serialVersionUID = -7365603455360754828L;

    /**
     * 加积分结果
     */
    private String status;
    /**
     * 积分余额
     */
    private Long credits;
    /**
     * 开发者业务ID
     */
    private String bizId;
    /**
     * 加积分失败错误信息
     */
    private String errorMessage;

    public boolean getSuccess(){
        return this.status != null && ("success".equalsIgnoreCase(status) || "ok".equalsIgnoreCase(status));
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Long getCredits() {
        return credits;
    }

    public void setCredits(Long credits) {
        this.credits = credits;
    }

    public String getBizId() {
        return bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}
