package cn.com.duiba.thirdparty.api.boc;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.thirdparty.dto.boc.BocTaskDto;
import cn.com.duiba.thirdparty.dto.boc.BocTaskInfoDto;
import cn.com.duiba.thirdparty.dto.boc.BocTaskRequestDto;
import cn.com.duiba.thirdparty.dto.boc.GetWxCardDto;
import cn.com.duiba.thirdparty.dto.boc.UseWxCardDto;

import java.util.List;

/**
 * @Author: fss
 * @Date: 2021/12/22 09
 * @Description:福建中行
 */
@AdvancedFeignClient
public interface RemoteBocService {
    /**
     * 星速台接口查询当前用户是否游戏首次入榜
     *
     * @param partnerUserId
     * @param month
     * @param appId
     * @return
     */
    Boolean queryConsumerRank(String partnerUserId, String month, Long appId);

    /**
     * 用户领取微信立减金卡券接口
     *
     * @param merOrderNo   调用方生成的订单号（不重复，长度不超过50）
     * @param userNo       用户唯一标识（金科提供）
     * @param cardId       权益卡券id，需要在权益中台配置，盈天地提供
     * @param activityId   活动id（调用方提供）
     * @param activityName 活动名称（调用方提供）
     * @return 调用接口返回异常时返回null
     */
    GetWxCardDto getWxCard(String merOrderNo, String userNo, String cardId, String activityId, String activityName);

    /**
     * 用户使用微信立减金卡券接口
     *
     * @param cardNo     微信立减金卡券号(getWxCard返回的值)
     * @param userNo     用户唯一标识（金科提供）
     * @param merOrderNo 调用方生成的订单号（不重复，长度不超过50）
     * @return 调用接口返回异常时返回null
     */
    UseWxCardDto useWxCard(String cardNo, String userNo, String merOrderNo);

    /**
     * 任务查询接口
     *
     * @param unionNo
     * @param taskList
     * @return 调用接口返回异常时返回null
     */
    List<BocTaskDto> queryTaskInfo(String unionNo, List<BocTaskRequestDto> taskList);
}
