package cn.com.duiba.thirdparty.api;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.thirdparty.dto.ConsumerCreditsLogSaveDto;

/**
 * @author fss
 */
@AdvancedFeignClient
public interface RemoteConsumerCreditsLogService {

    /**
     * 保存积分流水（过期积分后，调用生成记录）
     * @param consumerCreditsLogSaveDto
     * @return
     * @throws BizException
     */
    Long saveExpireLog(ConsumerCreditsLogSaveDto consumerCreditsLogSaveDto) throws BizException;


    /**
     * 保存积分流水
     * 开发者自有活动，积分流水同步
     *
     * @param consumerCreditsLogSaveDto
     * @return
     * @throws BizException
     */
    Long saveSyncLog(ConsumerCreditsLogSaveDto consumerCreditsLogSaveDto) throws BizException;

}
