package cn.com.duiba.thirdparty.api.huaxizi;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.order.center.api.dto.AmbPostsaleOrdersDto;
import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.thirdparty.dto.huaxizi.HuaXiZiCreditsResultDTO;
import cn.com.duiba.thirdparty.dto.huaxizi.HuaXiZiUserDto;
import cn.com.duiba.thirdparty.dto.huaxizi.QueryUserCreditsParam;
import cn.com.duiba.thirdparty.dto.huaxizi.QueryUserParam;

/**
 * 花西子服务接口
 */
@AdvancedFeignClient
public interface RemoteHuaXiZiService {

    /**
     * 查询用户信息
     * @param param
     * @return
     */
    HuaXiZiUserDto getUserInfo(QueryUserParam param) throws BizException;


    /**
     * 售后订单推送
     * @param postsaleOrder
     * @throws BizException
     */
    void postSaleSubmitOrderPush(AmbPostsaleOrdersDto postsaleOrder) throws BizException;

    /**
     * 售后订单完成/取消
     * @param postsaleOrder
     * @throws BizException
     */
    void postSaleCloseOrderPush(AmbPostsaleOrdersDto postsaleOrder) throws BizException;


    /**
     * 查询用户积分信息
     * @param param
     * @return
     * @throws BizException
     */
    HuaXiZiCreditsResultDTO queryHuaXiZiCreditsDetail(QueryUserCreditsParam param) throws BizException;

    /**
     * 花西子订单同步
     * @param order
     * @param orderStatus
     */
    void orderExec(OrdersDto order, String orderStatus);
}
