package cn.com.duiba.thirdparty.api.tailong;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.alibaba.fastjson.JSONObject;

import java.util.Map;

/**
 * @description: 泰隆银行相关接口
 * @author: cxh
 * @date: 2021-07-20 17:55
 */
@AdvancedFeignClient
public interface RemoteTaiLongService {


    /**
     * 定制提供给custom-web调用
     * @param paramMap
     * @param headMap
     * @param serviceId
     * @return
     */
    public String getCustomVirtualResult(Map<String, ?> paramMap, Map<String, ?> headMap, String serviceId);


    /**
     * 获取projectId做转发用
     * custom-web jar提高有冲突
     * 因此解密放在改服务做
     * @param body
     * @return
     */
    public String getProjectId(String body);

    /**
     * 使用泰隆银行通用的解密方法解密请求报文
     *
     * @param rspJsonObj 请求报文
     * @return 解密后的请求报文
     */
    JSONObject doEncrypt(JSONObject rspJsonObj);

    /**
     * 使用泰隆银行通用的加密方法加密响应报文
     *
     * @param reqJsonObj 响应求报文
     * @return 加密后的响应报文
     */
    JSONObject doDecrypt(JSONObject reqJsonObj);
}
