package cn.com.duiba.thirdparty.dto.hsbc.param;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * @Author: fss
 * @Date: 2022/10/11 10
 * @Description:
 */
public class HsbcPreWithdrawParam implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * uid
     */
    private String uid;

    /**
     * 兑吧appId
     */
    private Long duibaAppId;

    /**
     * 提现金额
     */
    private Long withdrawRedEnvelopeValue;

    /**
     * 描述
     */
    private String description;

    /**
     * 单号
     */
    private String orderNum;

    /**
     * 提现手续费
     */
    private Long commssion;

    /**
     * 元转分
     * @param bigDecimal
     * @return
     */
    public static Long bigDecimal2Long(BigDecimal bigDecimal) {
        return bigDecimal.multiply(new BigDecimal(100)).longValue();
    }

    /**
     * 分转元
     * @param amount
     * @return
     */
    public static BigDecimal long2BigDecimal(Long amount) {
        return new BigDecimal(amount).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP);
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public Long getDuibaAppId() {
        return duibaAppId;
    }

    public void setDuibaAppId(Long duibaAppId) {
        this.duibaAppId = duibaAppId;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public Long getWithdrawRedEnvelopeValue() {
        return withdrawRedEnvelopeValue;
    }

    public void setWithdrawRedEnvelopeValue(Long withdrawRedEnvelopeValue) {
        this.withdrawRedEnvelopeValue = withdrawRedEnvelopeValue;
    }

    public Long getCommssion() {
        return commssion;
    }

    public void setCommssion(Long commssion) {
        this.commssion = commssion;
    }
}
