package cn.com.duiba.thirdparty.enums.virtual;

public enum VirtualItemChannelEnum {

    FULU("fulu", "福禄"),
    HUAZHU("huazhu", "华住"),
    BILIBILI("bilibili", "哔哩哔哩"),
    PU_SHANG("pushang", "浦上"),
    SHANG_YU("shangyu", "尚娱"),
    QING_TIAN("qingtian", "晴天"),
    SUCCESS("success","成功"),
    FAIL("fail","失败"),
    TIME_OUT("timeout","超时"),
    ALIPAY_IGR("alipayIGR", "杭州兑吧支付宝立减金"),
    FJ_DB_WXLJJ("fjdbwxljj", "福建兑吧微信立减金"),
    DB_FJ_WXLJJ("dbfjwxljj", "兑吧福建微信立减金"),
    FUJIAN_DUIBA_ALIPAY_IGR("fujianDuibaAlipayIGR", "福建兑吧支付宝立减金"),
    DUIBA_FUJIAN_ALIPAY_IGR("duibaFujianAlipayIGR", "兑吧福建支付宝立减金"),
    PS_WX_RED_PACKET("psWxRedPacket", "浦上微信红包"),
    PS_ALIPAY_CHARGE("psAlipayCharge", "浦上支付宝直充"),
    JIGAO("jigao", "继皋"),
    YI_PAI("yipai", "易派"),
    HLX("hlx", "和路雪"),
    WX_REDPACK("wxRedpack", "微信红包"),
    IQIYI_MEMBER("iqiyiMember", "爱奇艺会员"),
    ;

    private String code;
    private String desc;

    VirtualItemChannelEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static VirtualItemChannelEnum getByCode(String code) {
        for (VirtualItemChannelEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

}
