package cn.com.duiba.thirdparty.alarm;

import cn.com.duiba.thirdparty.util.MailConstant;
import cn.com.duiba.thirdparty.dto.MailEntity;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;

import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;

/**
 * 邮件消息
 */
public class Mail {

    private Mail(){
        //do nothing for fixing sonar issue
    }

    /**
     * 发送邮件
     * @param toMail
     * @param subject
     * @param text
     * @param isHtml
     * @return
     * @throws Exception
     */
    public static boolean send(String[] toMail, String subject, String text, boolean isHtml) throws MessagingException {
        MailEntity entity = new MailEntity();
        entity.setTo(toMail);
        entity.setSubject(subject);
        entity.setFrom("system@duiba.com.cn");
        entity.setPassword("gGisd7c1UP0pBMt2");
        entity.setContentText(text);
        entity.setHtml(isHtml);

        send(entity);
        return true;
    }

    /**
     * 通用的发送邮件入口
     *
     * @param entity 所有参数均为必传
     * @return true发送成功
     * @throws MessagingException e
     */
    public static boolean send(MailEntity entity) throws MessagingException {
        JavaMailSenderImpl sender = new JavaMailSenderImpl();

        sender.setHost(MailConstant.HOST);
        sender.setPort(MailConstant.PORT);
        sender.setProtocol(MailConstant.PROTOCOL);
        sender.setUsername(entity.getFrom());
        sender.setPassword(entity.getPassword());
        sender.setDefaultEncoding(MailConstant.ENCODING);

        Session session = Session.getInstance(MailConstant.props);
        sender.setSession(session);

        doSend(sender, entity);
        return true;
    }

    private static void doSend(JavaMailSenderImpl sender, MailEntity entity) throws MessagingException {
        MimeMessage mail = sender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(mail);
        helper.setTo(entity.getTo());
        helper.setSubject(entity.getSubject());
        helper.setFrom(entity.getFrom());
        helper.setText(entity.getContentText(), entity.getHtml());
        sender.send(mail);
    }

}
