package cn.com.duiba.biz.credits;

import cn.com.duiba.biz.tool.duiba.subcredits.SubCreditsMsgDto;
import cn.com.duiba.config.HaidilaoConfigBean;
import cn.com.duiba.constant.HaidilaoSdkConstant;
import cn.com.duiba.credits.sdk.CreditNotifyParams;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.HaidilaoSignTool;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.vo.CouponSendRequestVO;
import cn.com.duiba.vo.HaidilaoVirtualVO;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * 海底捞定制
 * */
@Service
public class HaidilaoApi {

    private static final Logger logger = LoggerFactory.getLogger(HaidilaoApi.class);

    private static final String DELIMITER = "?";

    private static final String VIRTUAL_ADDCREDITS = "addCredits";

    private static final String VIRTUAL_SEND = "send";

    //虚拟商品 加积分 type 值
    private static final String VIRTUAL_ADD_TYPE = "reward";

    @Autowired
    private AppDAO appDAO;

    @Autowired
    HaidilaoConfigBean haidilaoConfigBean;


    /**
     *
     * 海底捞 扣积分请求
     * */
    public CreditsMessage getSubCreditsMessage(CreditsMessage request) {

        try {
            String url = request.getHttpUrl();
            String host = getGateway(url);

            /** 取出原始参数*/
            Map<String, String> originalParams = request.getAuthParams();

            /** 定义参数*/
            Map<String, String> paramsMap = bulidParms(originalParams);
            request.setAuthParams(paramsMap);

            request.setHttpType(CreditsMessage.HTTP_GET);
            request.setHttpUrl(AssembleTool.assembleUrl(host, paramsMap));

        } catch (Exception e) {
            logger.error("[HaidilaoApi-getSubCreditsMessage]error:{}", e);
        }
        return request;
    }

    /**
     * 海底撈 mq 扣积分 参数构造
     * */
    public SubCreditsMsgWrapper getRequestCredits(SubCreditsMsgWrapper request) {

        String url = request.getHttpUrl();

        String host = url.substring(0, url.indexOf('?'));
        //  请求参数
        Map<String, String> originalParams = request.getSubCreditsMsg().getAuthParams();

        /** 定义参数*/
        Map<String, String> paramsMap = bulidParms(originalParams);
        request.getSubCreditsMsg().setAuthParams(paramsMap);
        request.getSubCreditsMsg().setHttpType(SubCreditsMsgDto.HTTP_GET);
        request.setHttpUrl(AssembleTool.assembleUrl(host, paramsMap));
        return request;
    }

    /**
     * 海底捞定制加积分接口
     * */
    public CreditsMessageDto getAddCreditsMessage(CreditsMessageDto request){
        try {
            String url = request.getHttpUrl();
            String host = getGateway(url);

            /** 取出原始参数*/
            Map<String, String> originalParams = request.getAuthParams();

            /** 定义参数*/
            Map<String, String> paramsMap = bulidAddParms(originalParams);
            request.setAuthParams(paramsMap);

            request.setHttpType(CreditsMessage.HTTP_GET);
            request.setHttpUrl(AssembleTool.assembleUrl(host, paramsMap));
        } catch (Exception e) {
            logger.error("[HaidilaoApi-getAddCreditsMessage]error:{}", e);
        }
        return request;
    }


    /**
     * 虚拟商品上游兑换Request
     * @param request
     * @return
     */
    public SupplierRequest getVirtualRequest(SupplierRequest request){
        String url = request.getHttpUrl();
        String host = url.substring(0, url.indexOf('?'));

        String urlParams = url.substring(url.indexOf('?') + 1, url.length());
        // 1.将请求URL的参数转换为MAP
        Map<String, String> crediMap = AssembleTool.getUrlParams(urlParams);
        //判断是否是 加积分 lb_ 开头
        String keys = crediMap.get("params").trim();
        if(keys.startsWith(haidilaoConfigBean.getVirtualAddPre())){
            //  加积分  type 定为 reward
            crediMap.put("type",VIRTUAL_ADD_TYPE);
            crediMap.put("credits",keys.substring(haidilaoConfigBean.getVirtualAddPre().trim().length()).trim());

            CreditsMessageDto dto = new CreditsMessageDto();
            dto.setHttpUrl(haidilaoConfigBean.getVirtualAddCreditsUrl());
            dto.setAuthParams(crediMap);
            CreditsMessageDto messageDto = getAddCreditsMessage(dto);
            request.setAuthParams(messageDto.getAuthParams());
            request.setHttpUrl(messageDto.getHttpUrl());
            /** 借助 bizType 作为 加积分和发券的判断 */
            request.setBizType(VIRTUAL_ADDCREDITS);
            return request;
        }else if(keys.startsWith(haidilaoConfigBean.getHuowuGamePre())){
            //火舞游戏
            Map<String, String> authParams = Maps.newHashMap();
            authParams.put("appKey",crediMap.get("appKey"));
            authParams.put("orderNum",crediMap.get("orderNum"));
            authParams.put("uid",crediMap.get("uid"));
            authParams.put("params",crediMap.get("params"));
            if(StringUtils.isNotBlank(crediMap.get("description"))){
                authParams.put("description",crediMap.get("description"));
            }
            authParams.put("timestamp",String.valueOf(System.currentTimeMillis()));
            authParams.put("developBizId",crediMap.get("developBizId"));
            authParams.put("sign",sign(authParams,Long.valueOf(request.getAppId())));
            authParams.remove("appSecret");

            request.setHttpUrl(haidilaoConfigBean.getHuowuGameUrl().trim());
            request.setAuthParams(authParams);
            request.setBizType(haidilaoConfigBean.getHuowuGamePre());
            return request;
        }else{
            //发券
           // 测试template_id 20180621152740495376
            CouponSendRequestVO csrDto = new CouponSendRequestVO();
            csrDto.setOut_trade_no(crediMap.get("orderNum"));
            csrDto.setTemplate_id(keys);
            csrDto.setUid(crediMap.get("uid"));

            Map<String, String> authParams = Maps.newHashMap();
            authParams.put("method","coupon_send");
            authParams.put("coupon_send_request",JSONObject.toJSONString(csrDto));

            request.setHttpUrl(haidilaoConfigBean.getSendVirtualUrl());
            request.setAuthParams(authParams);
            /** 借助 bizType 作为 加积分和发券的判断 */
            request.setBizType(VIRTUAL_SEND);
            return request;
        }

    }

    /**
     * 海底捞定制接口
     * */
    public HttpRequestBase getRequestNotify(String notifyUrl, NotifyQueueDO record, AppDO app, CreditNotifyParams notifyParams) {

        Map<String, String> authParams = new HashMap<>();
        Long timestamp = System.currentTimeMillis();
        authParams.put("success", String.valueOf(notifyParams.isSuccess()));
        authParams.put("bizId", notifyParams.getBizId());
        authParams.put("timestamp", String.valueOf(timestamp));
        authParams.put("uid", record.getPartnerUserId());
        authParams.put("orderNum", notifyParams.getOrderNum());
        authParams.put("appKey",haidilaoConfigBean.getHaidilaoAppKey());
        if (!record.getResult()) {
            authParams.put("errorMessage", org.apache.commons.lang3.StringUtils.isBlank(record.getError4developer()) ? "未知原因" : record.getError4developer());
        }
        HttpRequestBase http = new HttpGet(AssembleTool.assembleUrl(notifyUrl, authParams));
        /** 定制 header处理 */
        setNotifyHttpHeader(authParams,record.getAppId(),http,notifyUrl);
        return http;
    }


    /**
     * 海底捞回調通知header处理
     * */
    public void setNotifyHttpHeader(Map<String, String> authParams,Long appId, HttpRequestBase http,String notifyUrl){
        CreditsMessage dto = new CreditsMessage();
        dto.setAppId(appId.toString());
        dto.setHttpType(CreditsMessage.HTTP_GET);
        dto.setHttpUrl(notifyUrl);
        Map<String,String> map = Maps.newHashMap();
        dto.setAuthParams(authParams);
        setHttpHeader(dto,http,true);

    }

    /**
     * 海底捞 虚拟 发券 定制header处理
     * */
    public HttpRequestBase setHaidilaoVirtualHttpHeader(SupplierRequest request,HttpRequestBase http){
        CreditsMessage dto = new CreditsMessage();
        dto.setHttpUrl(request.getHttpUrl());
        dto.setAuthParams(request.getAuthParams());
        dto.setAppId(request.getAppId());

        //判断 加积分还是 发券
        if(StringUtils.equals(VIRTUAL_ADDCREDITS,request.getBizType()) ){
            // 加积分
            http = new HttpGet(request.getHttpUrl());
            dto.setHttpType(CreditsMessage.HTTP_GET);
            setHttpHeader(dto,http,true);
        }else if(StringUtils.equals(haidilaoConfigBean.getHuowuGamePre(),request.getBizType())){
            // 火舞游戏
            http = new HttpGet(AssembleTool.assembleUrl(request.getHttpUrl(),request.getAuthParams()));

        }else{
            //发券
            http = AssembleTool.assembleRequestJson(request.getHttpUrl(), getSendDto(request.getAuthParams()));
            dto.setHttpType(CreditsMessage.HTTP_POST);
            setHttpHeader(dto,http,false);

        }
        return http;

    }

    /** 海底捞定制 header 处理
     *
     * isFormType 判断是否为 表单形式传参
     * */
    public void setHttpHeader(CreditsMessage request, HttpRequestBase http,boolean isFormType){

        long timestemp = System.currentTimeMillis();
        Map<String,String> headersParams = getHeaders(timestemp,isFormType);
        for(Map.Entry<String,String> entry:headersParams.entrySet()){
            http.setHeader(entry.getKey(),entry.getValue());
        }
        // 非form表单请求
        if(!isFormType){
            String contentMd5 =  HaidilaoSignTool.getContentMd5(getSendDto(request.getAuthParams()));
            headersParams.put(HaidilaoSdkConstant.CLOUDAPI_CONTENT_MD5,contentMd5);
            http.setHeader(HaidilaoSdkConstant.CLOUDAPI_CONTENT_MD5,contentMd5);
        }
        headersParams.remove(HaidilaoSdkConstant.CLOUDAPI_X_CA_SIGNATURE_HEADERS);

        Map<String,String > queryParams = request.getHttpType().toLowerCase().equals(CreditsMessage.HTTP_GET) ? request.getAuthParams():null;
        String path = getPath(request);
        //签名
        http.setHeader(HaidilaoSdkConstant.CLOUDAPI_X_CA_SIGNATURE,
                HaidilaoSignTool.sign(request.getHttpType().toUpperCase(),
                        haidilaoConfigBean.getHaidilaoAppSecret(),
                        headersParams,
                        path,
                        queryParams,
                        null));
    }


    /**
     * 参数 json转化
     * */
   private String getSendDto(Map<String,String> authParams){

       CouponSendRequestVO csrDto = JSONObject.parseObject(authParams.get("coupon_send_request"),CouponSendRequestVO.class);
       HaidilaoVirtualVO hvDto = new HaidilaoVirtualVO();
       hvDto.setCoupon_send_request(csrDto);
       hvDto.setMethod(authParams.get("method"));

       return JSONObject.toJSONString(hvDto);

   }

    public  String getPath(CreditsMessage request){
        String uri = request.getHttpUrl();
        if(StringUtils.isNotBlank(uri)){
            int begin = uri.indexOf("com/")+3;
            int end = uri.indexOf("?");
            if(-1 == begin){
                return null;
            }
            return -1 != end ? uri.substring(begin,end) : uri.substring(begin);
        }
        return null;
    }


    /**
     *构造headers
     * */
    private Map<String,String> getHeaders(long timestamp,boolean isFormType){
        Map<String,String> headersMap = Maps.newHashMap();
        headersMap.put(HaidilaoSdkConstant.CLOUDAPI_X_CA_KEY,haidilaoConfigBean.getHaidilaoAppKey());
        headersMap.put(HaidilaoSdkConstant.CLOUDAPI_X_CA_TIMESTAMP,String.valueOf(timestamp));
        headersMap.put(HaidilaoSdkConstant.CLOUDAPI_X_CA_NONCE,String.valueOf(UUID.randomUUID()) + String.valueOf(System.currentTimeMillis()));
        headersMap.put(HaidilaoSdkConstant.CLOUDAPI_X_CA_SIGNATURE_HEADERS,"X-Ca-Key,X-Ca-Timestamp,X-Ca-Nonce");

        headersMap.put("Accept", "text/xml,text/javascript");
        headersMap.put("User-Agent", "top-sdk-java");
        if(isFormType){
            headersMap.put("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
        }else {
            headersMap.put("Content-Type",HaidilaoSdkConstant.CLOUDAPI_CONTENT_TYPE_JSON);
        }

        headersMap.put("Accept-Encoding", "gzip");
        return headersMap;
    }

    /**
     * 截取 虚拟发券 响应
     * */
    public String getVirtualRespone(SupplierRequest message,String body) {
        JSONObject jsonBody;
        try {
            jsonBody = JSON.parseObject(body);
        } catch (Exception e) {
            logger.error("JSON.parseObject:", e);
            return body;
        }
        JSONObject json = JsonTool.getAllJson(jsonBody);

        Map<String, String> duibaDoc = new HashMap<>();
        //判断是否为加积分
        if(VIRTUAL_ADDCREDITS.equals(message.getBizType())){
            String status = "ok".equals(json.getString("status")) ? "success": "fail";
            duibaDoc.put("status",status);
            duibaDoc.put("errorMessage", json.getString("errorMessage"));
            duibaDoc.put("supplierBizId", json.getString("bizId"));
            duibaDoc.put("credits", json.getString("credits"));
        }else if(haidilaoConfigBean.getHuowuGamePre().equals(message.getBizType())){
            //判断是否为火舞游戏
            duibaDoc.put("status",json.getString("status"));
            duibaDoc.put("errorMessage", json.getString("errorMessage"));
            duibaDoc.put("supplierBizId", json.getString("supplierBizId"));
        }else {
            String supplierBizId = "";
            if(null != json.get("coupon_template")){
                String jsonString  = JSONObject.toJSONString(json.get("coupon_template"));
                JSONObject couponJson = JSON.parseObject(jsonString);
                supplierBizId = couponJson.getString("template_id");
            }
            //发券
            String status = "0".equals(json.getString("status").trim()) ? "success": "fail";
            duibaDoc.put("status",status);
            duibaDoc.put("errorMessage",
                    json.getString("msg"));
            duibaDoc.put("supplierBizId", supplierBizId);

        }

        return JsonTool.objectToJson(duibaDoc);
    }



    /**
     * 获取接口网关
     *
     * @param url
     * @return java.lang.String
     * @throw
     */
    private String getGateway(String url) {
        if (StringUtils.isNotBlank(url)) {
            int index = url.indexOf(DELIMITER);
            if (index != -1) {
                return url.substring(0, index);
            }
        }
        return url;
    }

    /**
     * 构造参数
     * */
    private Map<String,String> bulidParms( Map<String, String> originalParams){
        Map<String, String> paramsMap = Maps.newHashMap();
        paramsMap.put("uid",originalParams.get("uid"));
        paramsMap.put("description",originalParams.get("description"));
        paramsMap.put("credits",originalParams.get("credits"));
        paramsMap.put("orderNum",originalParams.get("orderNum"));
        if(StringUtils.isNotBlank(originalParams.get("itemCode"))){
            paramsMap.put("itemCode",originalParams.get("itemCode"));
        }
        paramsMap.put("appKey",haidilaoConfigBean.getHaidilaoAppKey());
        paramsMap.put("timestamp",originalParams.get("timestamp"));
        paramsMap.put("type",originalParams.get("type"));
        paramsMap.put("facePrice",originalParams.get("facePrice"));
        paramsMap.put("actualPrice",originalParams.get("actualPrice"));
        if(StringUtils.isNotBlank(originalParams.get("ip"))){
            paramsMap.put("ip",originalParams.get("ip"));
        }
        if(StringUtils.isNotBlank(originalParams.get("params"))){
            paramsMap.put("params",originalParams.get("params"));
        }
        paramsMap.put("waitAudit",originalParams.get("waitAudit"));

        return paramsMap;
    }

    /**
     * 构造参数
     * */
    private Map<String,String> bulidAddParms( Map<String, String> originalParams){
        Map<String, String> paramsMap = Maps.newHashMap();

        paramsMap.put("appKey",haidilaoConfigBean.getHaidilaoAppKey());
        paramsMap.put("description",originalParams.get("description"));
        paramsMap.put("uid",originalParams.get("uid"));
        paramsMap.put("credits",originalParams.get("credits"));
        paramsMap.put("type",originalParams.get("type"));
        paramsMap.put("orderNum",originalParams.get("orderNum"));
        paramsMap.put("timestamp",originalParams.get("timestamp"));
        if(StringUtils.isNotBlank(originalParams.get("ip"))){
            paramsMap.put("ip",originalParams.get("ip"));
        }

        return paramsMap;
    }


    /**
     * 转义海底捞扣积分响应数据
     *
     * @param body
     * @return
     */
    public String parseCreditsRsp(String body) {
        try {
            JSONObject jsonBody = JSON.parseObject(body);
            JSONObject json = JsonTool.getAllJson(jsonBody);

            Map<String, String> duibaDoc = new HashMap<>();
            //String status = "ok".equals(json.getString("status")) ? "success": "fail";
            duibaDoc.put("status",json.getString("status"));
            duibaDoc.put("errorMessage", json.getString("errorMessage"));
            duibaDoc.put("bizId", json.getString("bizId"));
            duibaDoc.put("credits", json.getString("credits"));

            return JsonTool.objectToJson(duibaDoc);
        } catch (Exception e) {
            logger.error("[HaidilaoApi-parseCreditsRsp]海底捞请求异常，响应信息："+body+",响应解析出错:{}", e);
            return body;
        }

    }

/**
 * 海底捞 火舞游戏 签名 规则按照 我们这边方式
 *
 * */
    private String sign(Map<String, String> params,Long appId) {
        AppDO app = appDAO.getAppByCache(appId);
        String appSecret = appDAO.getAppSecret(app);

        //params.put("appSecret","H8gW183qLFDKmiDPN3ae3g6d6y9");
        params.put("appSecret",appSecret.trim());
        return SignTool.sign(params);
    }


}
