package cn.com.duiba.biz.credits;

import cn.com.duiba.order.center.api.dto.CreditsCallbackMessage;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.service.ConsumerCreditsLogService;
import cn.com.duiba.service.CustomService;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.service.MessageService;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.thirdparty.enums.CallbackChannelTypeEnum;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.CaiNiaoTool;
import cn.com.duiba.tool.HttpRequestLog;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.wolf.utils.NumberUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ExecutorService;

/**
 * 扣积分服务类
 */
@Service
public class SubCreditsToDeveloper {

	private static final Logger logger = LoggerFactory.getLogger(SubCreditsToDeveloper.class);

	@Autowired
	private MessageService messageService;

	@Autowired
	private HttpAsyncClientPool httpAsyncClientPool;

	@Autowired
	private CustomService customService;

	@Autowired
	private DefaultMQProducer rocketMqProducer;

	@Autowired
	private ConsumerCreditsLogService consumerCreditsLogService;

	@Resource(name = "httpCallbackExecutorService")
	private ExecutorService httpCallbackExecutorService;


	/**
	 * https://openapi.ele.me/biz/pointmall/deduct_point?actualPrice=0&ip=36.7.210.117&sign=d6bd1273cc6d4b20c1bac46aecfa3f0b&description=%E6%B4%BB%E5%8A%A8%E5%B7%A5%E5%85%B7%2C%E6%9D%A5%E9%A2%86%E5%9C%A3%E8%AF%9E%E7%BA%A2%E5%8C%85%E5%90%A7&orderNum=hdtool-527187735283540667&waitAudit=false&type=htool&params=&uid=259477755&credits=9&facePrice=0&appKey=2pcWUCB4sNQjbDvxdcEsbvfautqw&timestamp=1513762358982&
	 * 提交扣积分HTTP请求
	 * @param req
	 * @param msgTopic
	 * @param msgTag
	 * @param msgKey
	 */
	public void submit(CreditsMessage req, final String msgTopic, final String msgTag, final String msgKey) {
		final CreditsMessage request = customService.getRequestCredits(req);
		HttpRequestBase http;
		if (CreditsMessage.HTTP_POST.equals(request.getHttpType())) {
			Map<String, String> authParams =  request.getAuthParams();
			if (MapUtils.isNotEmpty(authParams)) {
				// 移除appSecret
				authParams.remove("appSecret");
			}
			http = AssembleTool.assembleRequest(request.getHttpUrl(), request.getAuthParams());
			HttpRequestLog.logUrl("[action subCredits] [tag request] [bizId " + request.getRelationId() + "] [type " + request.getRelationType() + "] [post url " + request.getHttpUrl() + "][authParams "+request.getAuthParams()+"][consumerId " + request.getConsumerId() + "]" );
		} else {
			http = new HttpGet(request.getHttpUrl());
			HttpRequestLog.logUrl("[action subCredits] [tag request] [bizId " + request.getRelationId() + "] [type " + request.getRelationType() + "] [get url " + request.getHttpUrl() +"][consumerId " + request.getConsumerId() + "]");
		}

		setHttpHeader(request, http);

		httpAsyncClient(request,http,msgTopic,msgTag,msgKey);
	}

	private void httpAsyncClient(final CreditsMessage request,HttpRequestBase http,final String msgTopic, final String msgTag, final String msgKey){

		httpAsyncClientPool.submit(request.getAppId(), http, new FutureCallback<HttpResponse>() {
			@Override
			public void completed(HttpResponse response) {
				CreditsCallbackMessage resp = new CreditsCallbackMessage();
				try {
					resp.setCallbackType(CreditsCallbackMessage.CALLBACK_TYPE_COMPLETED);
					Header header = response.getEntity().getContentEncoding();
					String result;
					if (header != null && header.toString().contains(CaiNiaoTool.CONTENT_ENCODING_GZIP)) {
						result = EntityUtils.toString(new GzipDecompressingEntity(response.getEntity()));
					} else {
						result = EntityUtils.toString(response.getEntity());
					}
					String body = customService.getResponseCredits(NumberUtils.parseLong(request.getAppId(), 0L), result);
					resp.setMessage(HttpRequestLog.subBody(body));
				} catch (Exception e) {
					logger.error("toDeveloper completed", e);
				} finally {
					finallyBlock(request, resp, msgTopic, msgTag, msgKey, Integer.toString(response.getStatusLine().getStatusCode()));
				}
			}

			@Override
			public void failed(Exception ex) {
				logger.error("toDeveloper failed bizId:" + request.getRelationId() + " bizType:" + request.getRelationType(), ex);
				CreditsCallbackMessage resp = new CreditsCallbackMessage();
				try {
					resp.setCallbackType(CreditsCallbackMessage.CALLBACK_TYPE_FAILED);
					resp.setMessage(ex.getClass().getName() + ":" + ex.getMessage());
				} catch (Exception e) {
					logger.error("toDeveloper failed", e);
				} finally {
					finallyBlock(request, resp, msgTopic, msgTag, msgKey, "");
				}
			}

			@Override
			public void cancelled() {
				logger.info("toDeveloper cancelled bizId:" + request.getRelationId() + " bizType:" + request.getRelationType());
				CreditsCallbackMessage resp = new CreditsCallbackMessage();
				try {
					resp.setCallbackType(CreditsCallbackMessage.CALLBACK_TYPE_FAILED);
					resp.setMessage("http cancelled");
				} catch (Exception e) {
					logger.error("toDeveloper cancelled", e);
				} finally {
					finallyBlock(request, resp, msgTopic, msgTag, msgKey, "");
				}
			}

		});
	}

	/**
	 * set http header
	 * @param request
	 * @param http
	 */
	private void setHttpHeader(CreditsMessage request, HttpRequestBase http) {
		if(customService.isMobike(Long.valueOf(request.getAppId()))){
			String time=request.getParams().get("time");
			if(StringUtils.isNotEmpty(time)){//摩拜需要在header中传递参数
				http.setHeader(new BasicHeader("time",time));
				http.setHeader(new BasicHeader("accesstoken",request.getParams().get("accesstoken")));
			}
		}

		if(customService.isCainiao(Long.valueOf(request.getAppId()))){
			http.setHeader("Accept", "text/xml,text/javascript");
			http.setHeader("User-Agent", "top-sdk-java");
			http.setHeader("Content-Type", "application/x-www-form-urlencoded;charset=" + CaiNiaoTool.CHARSET_UTF8);
			http.setHeader("Accept-Encoding", CaiNiaoTool.CONTENT_ENCODING_GZIP);
		}
		if(customService.isHaiDiLao(Long.valueOf(request.getAppId()))){
			//海底捞定制header处理
			customService.setHaidilaoSubAndAddHttpHeader(request,http);
		}

	}

	/**
	 * 返回响应结果到业务放
	 * @param req
	 * @param resp
	 * @param msgTopic
	 * @param msgTag
	 * @param msgKey
	 */
	private void finallyBlock(CreditsMessage req, CreditsCallbackMessage resp, String msgTopic, String msgTag, String msgKey, String code) {
		try {
			resp.setRelationId(req.getRelationId());
			resp.setRelationType(req.getRelationType());
			resp.setParams(req.getParams());
			resp.setAppId(req.getAppId());
			resp.setConsumerId(req.getConsumerId());
			resp.setHttpUrl(req.getHttpUrl());
			String body = JsonTool.objectToJson(resp);
			if(req.getParams() != null && CallbackChannelTypeEnum.ROCKETMQ.getType().equals(req.getParams().get(CreditsMessageDto.MESSAGE_CHANNEL_TYPE_KEY))){
				sendRocketMQMessage(msgTopic, msgTag, msgKey, body);
			} else {
				messageService.sendMsg(msgTopic, msgTag, msgKey, body);
			}

			saveCreditsLog(req, resp);
		} catch (Exception e) {
			logger.error("credits callback: bizId:" + req.getRelationId() + " bizType:" + req.getRelationType(), e);
		} finally {
			HttpRequestLog.logUrl("[action subCredits] [tag response] [code "+code+"] [bizId " + req.getRelationId() + "] [type " + req.getRelationType() + "] [callback " + resp.getCallbackType() + "] [body " + resp.getMessage() + "]");
		}
	}

	private void sendRocketMQMessage(String topic, String tag, String key, String message){
		Message msg = new Message(topic, tag, key, message.getBytes(Charset.forName("utf-8")));
		try {
			rocketMqProducer.send(msg);
		} catch (Exception e) {
			logger.error("subCredits sendRocketMQMessage", e.getMessage());
		}
	}

	/**
	 * 保存积分记录
	 * @param body
	 * @param request
	 * @param response
	 */
	private void saveCreditsLog(CreditsMessage request, CreditsCallbackMessage response) {
		httpCallbackExecutorService.execute(() -> {
			try {
				if (CreditsCallbackMessage.CALLBACK_TYPE_COMPLETED.equals(response.getCallbackType())) {
					JSONObject json = JSON.parseObject(response.getMessage());
					if ("success".equalsIgnoreCase(json.getString("status")) || "ok".equalsIgnoreCase(json.getString("status"))) {
						consumerCreditsLogService.save(request, response);
					}
				}
			} catch (Exception e) {
				logger.error("积分记录保存失败, bizId={}, bizType={}", request.getRelationId(), request.getRelationType(), e);
			}
		});
	}
}