package cn.com.duiba.mq;


import cn.com.duiba.biz.tool.duiba.mq.EmailMsg;
import cn.com.duiba.biz.tool.duiba.subcredits.SubCreditsMsgDto;
import cn.com.duiba.biz.tool.duiba.util.GZIPCompressUtil;
import cn.com.duiba.crecord.message.CrecordAsyncHttp;
import cn.com.duiba.mq.dinghandler.SendDingMsgHelper;
import cn.com.duiba.notifycenter.service.NotifyService;
import cn.com.duiba.service.CreditsService;
import cn.com.duiba.service.DevAppTrustConfService;
import cn.com.duiba.service.EmailService;
import cn.com.duiba.thirdparty.mq.msg.NotifyDeveloperMsg;
import cn.com.duiba.thirdparty.mq.msg.ValidatePrizeTagMsg;
import cn.com.duiba.thirdparty.dto.NotifyQueueDto;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.common.message.MessageExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSONObject;

import java.nio.charset.Charset;
import java.util.List;
import java.util.Objects;

/**
 * Created by yansen on 17/5/5.
 */
@Component("bootRocketMqMessageListener")
public class RocketMqMessageListener implements MessageListenerConcurrently {

    private static Logger logger = LoggerFactory.getLogger(RocketMqMessageListener.class);

    @Autowired
    private DevAppTrustConfService devAppTrustConfService;

    @Autowired
    private RocketMQTopicConstant rocketMQTopicConstant;

    @Autowired
    private CrecordAsyncHttp crecordAsyncHttp;

    @Autowired
    private CreditsService creditsService;
    @Autowired
    private EmailService emailService;
    @Autowired
    private NotifyService notifyService;
    @Autowired
    private SendDingMsgHelper sendDingMsgHelper;

    /**
     * It is not recommend to throw exception,rather than returning ConsumeConcurrentlyStatus.RECONSUME_LATER if consumption failure
     *
     * @param msgs    msgs.size() >= 1<br> DefaultMQPushConsumer.consumeMessageBatchMaxSize=1,you can modify here
     * @param context
     * @return The consume status
     */
    @Override
    public ConsumeConcurrentlyStatus consumeMessage(List<org.apache.rocketmq.common.message.MessageExt> msgs, ConsumeConcurrentlyContext context) {
        try {
            //经过duiba-spring-boot-starter的内部限制，实际上msgs里只会包含一个消息，但是不排除将来可能会改为多个，而且每个消息的topic都不同
            for (MessageExt message : msgs) {
                String topic = message.getTopic();
                if (Objects.equals(rocketMQTopicConstant.getCrecordRequest(), topic)) {
                    String body = new String(message.getBody(), Charset.forName("utf-8"));
                    crecordAsyncHttp.asyncSubmit(body);
                } else if (Objects.equals(rocketMQTopicConstant.getSubCredits(), topic)) {
                    creditsService.subCredits(SubCreditsMsgDto.decode(message.getBody()));
                } else if (Objects.equals(rocketMQTopicConstant.getNotifyDeveloper(), topic)) {
                    creditsService.notifyDeveloper(NotifyDeveloperMsg.decode(message.getBody()));
                } else if (Objects.equals(rocketMQTopicConstant.getValidatePrizeTag(), topic)) {
                    devAppTrustConfService.sendDevPrizeTagMsg(ValidatePrizeTagMsg.decode(message.getBody()));
                } else if (Objects.equals(rocketMQTopicConstant.getSendEmail(), topic)) {
                    emailService.sendEmail(EmailMsg.decode(message.getBody()));
                }else if (Objects.equals(rocketMQTopicConstant.getNotifyQueue(), topic)) {
                	//解析 消息
                	String string = GZIPCompressUtil.ungzip(message.getBody());
            		if (string != null && !string.isEmpty()) {
            			NotifyQueueDto dto = JSONObject.parseObject(string, NotifyQueueDto.class);
            			notifyService.notifyFromMq(dto);
            		}
                } else if(Objects.equals(rocketMQTopicConstant.getDingMessage(), topic)){
                    sendDingMsgHelper.handleMqMessage(message);
                }else {
                    logger.warn("暂不应该有其他topic被消费, topic:{}, message:{}", topic, message);
                    //接口层现在是一条条拿，不是批量拿，所以加return没问题。但要注意如果mq server配置改了，接口层是批量拿会有问题
                    return ConsumeConcurrentlyStatus.RECONSUME_LATER;
                }
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            //发生异常时通常要重新消费，如果在发生特殊异常时你不希望该消息重新消费，则自行加个catch分支，并返回ConsumeConcurrentlyStatus.CONSUME_SUCCESS
            return ConsumeConcurrentlyStatus.RECONSUME_LATER;
        }
        return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
    }


}
