package cn.com.duiba.service.impl;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.biz.tool.duiba.dto.credits.CreditsRequest;
import cn.com.duiba.biz.tool.duiba.dto.credits.CreditsResponse;
import cn.com.duiba.dao.ConsumerCreditsLogDAO;
import cn.com.duiba.domain.ConsumerCreditsLogDO;
import cn.com.duiba.service.AppService;
import cn.com.duiba.service.ConsumerCreditsLogService;
import cn.com.duiba.service.SaasDevFreeService;
import cn.com.duiba.dto.AppSimpleDto;
import cn.com.duiba.thirdparty.dto.ConsumerCreditsLogSaveDto;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import javax.annotation.Resource;

/**
 * Created by fangdong on 2018/10/17
 */
@Service("consumerCreditsLogService")
public class ConsumerCreditsLogServiceImpl implements ConsumerCreditsLogService {
    private static final Logger log = LoggerFactory.getLogger(ConsumerCreditsLogServiceImpl.class);

    @Resource
    private ConsumerCreditsLogDAO consumerCreditsLogDAO;
    @Resource
    private SaasDevFreeService saasDevFreeService;
    @Resource
    private AppService appService;
    @Resource
    private CompositeCreditsLogExtractor extractor;

    @Override
    public Long save(ConsumerCreditsLogSaveDto creditsLog) {
        Assert.notNull(creditsLog, "ConsumerCreditsLogSaveDto不能为null");
        Assert.notNull(creditsLog.getAppId(), "appId不能为null");

        AppSimpleDto app = appService.getById(creditsLog.getAppId());
        Assert.notNull(app, "app不能为null");
        Long developerId = app.getDeveloperId();
        // 如果是ka开发者，不落积分流水
        if (saasDevFreeService.isExists(developerId)) {
            return 0L;
        }

        ConsumerCreditsLogDO entity = BeanUtils.copy(creditsLog, ConsumerCreditsLogDO.class);
        entity.setChangeType(creditsLog.getChangeType().getType());
        entity.setLogStatus(creditsLog.getLogStatus().getType());

        return consumerCreditsLogDAO.insert(entity);
    }

    @Override
    public Long save(CreditsRequest request, CreditsResponse response) {
        if (!extractor.supports(request, response)) {
            throw new ThirdpatyException("该creditsMessage不支持");
        }

        ConsumerCreditsLogSaveDto creditsLog = extractor.extract(request, response);
        if (creditsLog == null) {
            return 0L;
        }

        return this.save(creditsLog);
    }

}
