package cn.com.duiba.service.impl;

import cn.com.duiba.biz.tool.duiba.enums.HttpRequestResultType;
import cn.com.duiba.biz.tool.duiba.subcredits.SubCreditsMsgDto;
import cn.com.duiba.biz.tool.duiba.subcredits.SubCreditsResultMsgDto;
import cn.com.duiba.biz.tool.duiba.subcredits.SubCreditsType;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.mq.RocketMQMsgProducer;
import cn.com.duiba.notifycenter.dao.NotifyQueueDAO;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.notifycenter.service.NotifyService;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.service.ConsumerCreditsLogService;
import cn.com.duiba.service.CreditsService;
import cn.com.duiba.service.CustomService;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.thirdparty.enums.NotifyTypeEnum;
import cn.com.duiba.thirdparty.mq.msg.NotifyDeveloperMsg;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.CaiNiaoTool;
import cn.com.duiba.tool.HttpRequestLog;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Map;
import java.util.concurrent.ExecutorService;

@Service
public class CreditsServiceImpl implements CreditsService {

    private static final Logger LOG = LoggerFactory.getLogger(CreditsServiceImpl.class);

    @Autowired
    private ConsumerCreditsLogService consumerCreditsLogService;

    @Autowired
    private HttpAsyncClientPool httpAsyncClientPool;

    @Autowired
    private CustomService customService;

    @Autowired
    private RocketMQMsgProducer rocketMQMsgProducer;

    @Autowired
    private NotifyQueueDAO notifyQueueDAO;

    @Autowired
    private NotifyService notifyService;

    @Resource(name = "httpCallbackExecutorService")
    private ExecutorService httpCallbackExecutorService;

    @Override
    public void subCredits(SubCreditsMsgDto subCreditsMsg) {
        if (subCreditsMsg == null) {
            return;
        }
        SubCreditsMsgWrapper subCreditsMsgWrapper = new SubCreditsMsgWrapper(subCreditsMsg);
        final SubCreditsMsgWrapper request = customService.getRequestCredits(subCreditsMsgWrapper);
        HttpRequestBase http;
        if (SubCreditsMsgDto.HTTP_POST == request.getSubCreditsMsg().getHttpType()) {
            Map<String, String> authParams = request.getSubCreditsMsg().getAuthParams();
            if (MapUtils.isNotEmpty(authParams)) {
                // 移除appSecret
                authParams.remove("appSecret");
            }
            http = AssembleTool.assembleRequest(request.getHttpUrl(), request.getSubCreditsMsg().getAuthParams());
            HttpRequestLog.logUrl("[action subCredits] [tag request] [bizId " + request.getSubCreditsMsg().getRelationId() + "] [type " + request.getSubCreditsMsg().getRelationType() + "] [post url " + request.getHttpUrl() + "][authParams " + request.getSubCreditsMsg().getAuthParams() + "][consumerId " + request.getSubCreditsMsg().getConsumerId() + "]");
        } else {
            http = new HttpGet(request.getHttpUrl());
            HttpRequestLog.logUrl("[action subCredits] [tag request] [bizId " + request.getSubCreditsMsg().getRelationId() + "] [type " + request.getSubCreditsMsg().getRelationType() + "] [get url " + request.getHttpUrl() + "][consumerId " + request.getSubCreditsMsg().getConsumerId() + "]");
        }

        setHttpHeader(request.getSubCreditsMsg(), http, request);

        httpAsyncClient(request,http);
    }

    private void httpAsyncClient(final SubCreditsMsgWrapper request,HttpRequestBase http){
        httpAsyncClientPool.submit(String.valueOf(request.getSubCreditsMsg().getAppId()), http, new FutureCallback<HttpResponse>() {
            String body = "";

            @Override
            public void completed(HttpResponse response) {
                SubCreditsResultMsgDto resp = new SubCreditsResultMsgDto();
                try {
                    resp.setResultType(HttpRequestResultType.COMPLETED);
                    Header header = response.getEntity().getContentEncoding();
                    String result;
                    if (header != null && header.toString().contains(CaiNiaoTool.CONTENT_ENCODING_GZIP)) {
                        result = EntityUtils.toString(new GzipDecompressingEntity(response.getEntity()));
                    } else {
                        result = EntityUtils.toString(response.getEntity());
                    }
                    body = customService.getResponseCredits(request.getSubCreditsMsg().getAppId(), result);
                    parseResponseBody(resp, HttpRequestLog.subBody(body), request.getSubCreditsMsg().getAppId(), request.getSubCreditsMsg().getRelationId(), request.getSubCreditsMsg().getRelationType());
                } catch (Exception e) {
                    LOG.error("toDeveloper completed", e);
                } finally {
                    finallyBlock(request, resp, request.getSubCreditsMsg().getCallbackTopic(), request.getSubCreditsMsg().getCallbackTag(), request.getSubCreditsMsg().getCallbackTag(), Integer.toString(response.getStatusLine().getStatusCode()), HttpRequestLog.subBody(body));
                }
            }

            @Override
            public void failed(Exception ex) {
                LOG.error("toDeveloper failed bizId:" + request.getSubCreditsMsg().getRelationId() + " bizType:" + request.getSubCreditsMsg().getRelationType(), ex);
                SubCreditsResultMsgDto resp = new SubCreditsResultMsgDto();
                try {
                    resp.setResultType(HttpRequestResultType.FAILED);
                    resp.setResponse(ex.getMessage());
                } catch (Exception e) {
                    LOG.error("toDeveloper failed", e);
                } finally {
                    finallyBlock(request, resp, request.getSubCreditsMsg().getCallbackTopic(), request.getSubCreditsMsg().getCallbackTag(), request.getSubCreditsMsg().getCallbackTag(), "", HttpRequestLog.subBody(body));
                }
            }

            @Override
            public void cancelled() {
                LOG.info("toDeveloper cancelled bizId:" + request.getSubCreditsMsg().getRelationId() + " bizType:" + request.getSubCreditsMsg().getRelationType());
                SubCreditsResultMsgDto resp = new SubCreditsResultMsgDto();
                try {
                    resp.setResultType(HttpRequestResultType.CANCELLED);
                    resp.setResponse("http cancelled");
                } catch (Exception e) {
                    LOG.error("toDeveloper cancelled", e);
                } finally {
                    finallyBlock(request, resp, request.getSubCreditsMsg().getCallbackTopic(), request.getSubCreditsMsg().getCallbackTag(), request.getSubCreditsMsg().getCallbackTag(), "", HttpRequestLog.subBody(body));
                }
            }

        });
    }
//
//    @Override
//    public void addCredits() {
//        // TODO
//    }

    @Override
    public void notifyDeveloper(NotifyDeveloperMsg notifyDeveloperMsg) {
        try {
            NotifyQueueDO queue = BeanUtils.copy(notifyDeveloperMsg, NotifyQueueDO.class);
            if (queue.getTimes() == null) {
                queue.setTimes(0);
            }
            if (queue.getNotifyType() == null) {//默认结果通知，向上兼容
                queue.setNotifyType(NotifyTypeEnum.NOTIFY_RESULT.getCode());
            }
            if (NotifyTypeEnum.getByCode(queue.getNotifyType()) == null) {
                LOG.warn("通知类型不存在;queue:" + JSON.toJSONString(queue));
                return;
            }

            String errorMsg = queue.getError4developer();
            if (StringUtils.isNotBlank(errorMsg) && errorMsg.length() > 500) {
                queue.setError4developer(errorMsg.substring(0, 500));
            }

            notifyQueueDAO.insert(queue);
            notifyService.notify(queue, "remote call");
        } catch (Exception e) {
            LOG.error("notify error", e);
        }
    }


    /**
     * set http header
     *
     * @param request
     * @param http
     */
    private void setHttpHeader(SubCreditsMsgDto request, HttpRequestBase http,SubCreditsMsgWrapper subMsg ) {
        if (customService.isMobike(Long.valueOf(request.getAppId()))) {
            String time = request.getParams().get("time");
            if (StringUtils.isNotEmpty(time)) {//摩拜需要在header中传递参数
                http.setHeader(new BasicHeader("time", time));
                http.setHeader(new BasicHeader("accesstoken", request.getParams().get("accesstoken")));
            }
        }

        if (customService.isCainiao(Long.valueOf(request.getAppId()))) {
            http.setHeader("Accept", "text/xml,text/javascript");
            http.setHeader("User-Agent", "top-sdk-java");
            http.setHeader("Content-Type", "application/x-www-form-urlencoded;charset=" + CaiNiaoTool.CHARSET_UTF8);
            http.setHeader("Accept-Encoding", CaiNiaoTool.CONTENT_ENCODING_GZIP);
        }

        if(customService.isHaiDiLao(Long.valueOf(request.getAppId()))){
            //海底捞定制header处理
            CreditsMessage cmg = new CreditsMessage();
            cmg.setHttpType(http.getMethod());
            cmg.setHttpUrl(subMsg.getHttpUrl());
            cmg.setAuthParams(subMsg.getSubCreditsMsg().getAuthParams());
            customService.setHaidilaoSubAndAddHttpHeader(cmg,http);
        }
    }

    /**
     * 返回响应结果到业务放
     *
     * @param req
     * @param resp
     * @param msgTopic
     * @param msgTag
     * @param msgKey
     */
    private void finallyBlock(SubCreditsMsgWrapper req, SubCreditsResultMsgDto resp, String msgTopic, String msgTag, String msgKey, String code, String callbackBody) {
        String body = null;
        try {
            resp.setRelationId(req.getSubCreditsMsg().getRelationId());
            resp.setRelationType(req.getSubCreditsMsg().getRelationType());
            resp.setParams(req.getSubCreditsMsg().getParams());
            resp.setAppId(req.getSubCreditsMsg().getAppId());
            resp.setConsumerId(req.getSubCreditsMsg().getConsumerId());
            resp.setHttpUrl(req.getHttpUrl());
            body = JsonTool.objectToJson(resp);
            rocketMQMsgProducer.sendMsg(msgTopic, msgTag, msgKey, body, false, null);

            saveCreditsLog(req, resp);
        } catch (Exception e) {
            LOG.error("credits callback: bizId:" + req.getSubCreditsMsg().getRelationId() + " bizType:" + req.getSubCreditsMsg().getRelationType(), e);
        } finally {
            HttpRequestLog.logUrl("[action subCredits] [tag response] [code " + code + "] [bizId " + req.getSubCreditsMsg().getRelationId() +
                    "] [type " + req.getSubCreditsMsg().getRelationType() + "] [callback " + resp.getResultType() + "] [body " + callbackBody + "]");
        }
    }


    private void parseResponseBody(SubCreditsResultMsgDto subCreditsResultMsg, String body, Long appId, String relationId, SubCreditsType type) {
        JSONObject jsonObject = null;
        try {
            jsonObject = JSONObject.parseObject(body);
        } catch (Exception e) {
            if(body != null && body.length() > 100){
                body = body.substring(0, 100);
            }
            //暂时屏蔽到youku的返回结果为html格式错误，玉东已经在让对方的开发查原因，但对方还没有查明具体原因
            if("46112".equals(appId + "")){
                LOG.info("parse subCredits json fail, appId={}, bizId={}, type={}, body={}", appId, relationId, type, body);
            }else{
                LOG.warn("parse subCredits json fail, appId={}, bizId={}, type={}, body={}", appId, relationId, type, body);
            }

            subCreditsResultMsg.setCode(SubCreditsResultMsgDto.CODE_PARSE_JSON_FAIL);
            subCreditsResultMsg.setResponse(body);
            return;
        }

        if (jsonObject == null) {
            subCreditsResultMsg.setResponse(body);
            subCreditsResultMsg.setCode(SubCreditsResultMsgDto.CODE_PARSE_JSON_FAIL);
            return;
        }
        jsonObject = getOneDegreeJson(jsonObject);

        if ("ok".equalsIgnoreCase(jsonObject.getString("status"))) {
            subCreditsResultMsg.setCode(SubCreditsResultMsgDto.CODE_SUCCESS);
            Long credits = jsonObject.getLong("credits");
            if (credits != null && credits >= 0) {
                subCreditsResultMsg.setCredits(credits);
            }
            String bizId = jsonObject.getString("bizId");
            subCreditsResultMsg.setBizId(bizId);
        } else {
            // 扣积分失败
            subCreditsResultMsg.setCode(SubCreditsResultMsgDto.CODE_NORMAL_FAIL);
            subCreditsResultMsg.setErrorMessage(jsonObject.getString("errorMessage"));
            subCreditsResultMsg.setResponse(body);
        }
    }

    private JSONObject getOneDegreeJson(JSONObject o) {
        JSONObject json = new JSONObject();
        for (Map.Entry<String, Object> entry : o.entrySet()) {
            if (entry.getValue() instanceof JSONObject) {
                JSONObject json2 = (JSONObject) entry.getValue();
                for (Map.Entry<String, Object> entry2 : json2.entrySet()) {
                    json.put(entry2.getKey(), entry2.getValue());
                }
            } else {
                json.put(entry.getKey(), entry.getValue());
            }
        }
        return json;
    }

    /**
     * 保存积分记录
     * @param request
     * @param response
     */
    private void saveCreditsLog(SubCreditsMsgWrapper request, SubCreditsResultMsgDto response) {
        httpCallbackExecutorService.execute(() -> {
            try {
                if (HttpRequestResultType.COMPLETED.equals(response.getResultType())
                        && SubCreditsResultMsgDto.CODE_SUCCESS == response.getCode()) {
                    consumerCreditsLogService.save(request, response);
                }
            } catch (Exception e) {
                LOG.error("积分记录保存失败, bizId={}, bizType={}",
                        request.getSubCreditsMsg().getRelationId(), request.getSubCreditsMsg().getRelationType(), e);
            }
        });
    }

}
