package cn.com.duiba.service.impl;

import cn.com.duiba.biz.credits.*;
import cn.com.duiba.biz.virtual.AliTripApi;
import cn.com.duiba.credits.sdk.CreditNotifyParams;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.service.CustomService;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.thirdparty.dto.HttpRequestMessageDto;
import cn.com.duiba.tool.HttpRequestLog;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 接口自定义
 * cusomService应该看待成一个工厂，只起一个forward作用，任何定制的业务逻辑请放到定制的API中，避免散乱于各处
 */
@Service
public class CustomServiceImpl implements CustomService {

    private static Logger log = LoggerFactory.getLogger(CustomServiceImpl.class);

    //24202:沪江开心词场;27068L 搜狗阅读活动; 38854L 搜狗阅读活动测试
    private static final List<Long> NOTIFY_WITH_TRANSFER = Arrays.asList(24202L, 27068L, 38854L, 1l);

    /**
     * 平安健康的appID集合
     */
    private static final List<Long> pajkAppIds = Arrays.asList(27271L, 30703L, 31294L);

    private static final List<Long> mobikeIds=Arrays.asList(33888L,28651L,35830L);

    private static final List<Long> iqiyiIds=Arrays.asList(31819L,33713L,37066L,38347L);

    private static final List<Long> alisportsIds=Arrays.asList(21394L,36558L);

    private static final List<Long> youkuIds=Arrays.asList(45031L,46112L,46113L);

    private static final List<Long> taopiaopiaoIds=Arrays.asList(47077L,47074L);

    private static final List<Long> haidilaoIds = Arrays.asList(47663L,48685L);

    private static final List<Long> weiboAppIds = Arrays.asList(49006L);

    private static final List<Long> usePostAppIds = Arrays.asList(49006L);

    private static final List<Long> sohuzixunAppIds = Arrays.asList(47541L);


    @Value("${mogujie.appId}")
    private Long mogujieAppId;

    @Value("${taojinbi.appId}")
    private Long taojinbiAppId;

    //凤金积分商城
    @Value("${fengjin.appId}")
    private String fengJinAppId;

    @Autowired
    private MogujieApi mogujieApi;
    @Autowired
    private PajkApi pajkApi;
    @Autowired
    private TaojinbiApi taojinbiApi;

    @Autowired
    private MobikeApi mobikeApi;

    @Autowired
    private FengJinApi fengJinApi;

    @Autowired
    private IqiyiApi iqiyiApi;

    @Autowired
    private CainiaoApi cainiaoApi;

    @Autowired
    private AliTripApi aliTripApi;

    @Autowired
    private YoukuApi youkuApi;

    @Autowired
    private TaopiaopiaoApi taopiaopiaoApi;

    @Autowired
    private HaidilaoApi haidilaoApi;

    @Autowired
    private WeiboApi weiboApi;

    @Autowired
    private SohuzixunApi sohuzixunApi;

    public boolean isFengJin(Long appId){
        return fengJinAppId != null && Arrays.asList(fengJinAppId.replace(" ", "").split(",")).contains(appId + "");
    }

    @Override
    public boolean isMogujie(Long appId) {
        return mogujieAppId != null && mogujieAppId.equals(appId);
    }

    @Override
    public boolean isCainiao(Long appId) {
        return CainiaoApi.isCainiao(appId);
    }

    @Override
    public boolean isAliTrip(Long appId) {
        return AliTripApi.isAliTrip(appId);
    }

    @Override
    public boolean isPajk(Long appId) {
        return appId != null && pajkAppIds.contains(appId);
    }

    @Override
    public boolean isTaojinbi(Long appId) {
        return taojinbiAppId != null && taojinbiAppId.equals(appId);
    }
    @Override
    public boolean isMobike(Long appId){
        return mobikeIds.contains(appId);
    }

    @Override
    public boolean isIqiyi(Long appId) {
        return appId != null && iqiyiIds.contains(appId);
    }

    @Override
    public boolean isYouku(Long appId) { return appId != null && youkuIds.contains(appId); }

    @Override
    public boolean isTaopiaopiao(Long appId) { return appId != null && taopiaopiaoIds.contains(appId); }

    @Override
    public boolean isAlisports(Long appId) {
        return appId != null && alisportsIds.contains(appId);
    }

    @Override
    public boolean isHaiDiLao(Long appId) {
        return appId != null && haidilaoIds.contains(appId);
    }

    @Override
    public boolean isWeibo(Long appId){
        return appId != null && weiboAppIds.contains(appId);
    }

    @Override
    public boolean isSohuZiXun(Long appId){ return appId != null && sohuzixunAppIds.contains(appId); }

    @Override
    public CreditsMessage getRequestCredits(CreditsMessage request) {
        if (request.getAppId() == null) {
            return request;
        }
        Long appId = Long.valueOf(request.getAppId());
        if (isMogujie(appId)) {
            return mogujieApi.getMogujieRequestCredits(request);
        }
        if (isPajk(appId)) {
            return pajkApi.getPajkRequestCredits(request);
        }
        if (isTaojinbi(appId)) {
            return taojinbiApi.getCreditsMessage(request);
        }
        if(isMobike(appId)){
            return mobikeApi.buildSubCreditsRequest(request);
        }
        if (isFengJin(appId)) {
            return fengJinApi.getSubCreditsMessage(request);
        }
        if (isIqiyi(appId)) {
            return iqiyiApi.getSubCreditsMessage(request);
        }
        if (CainiaoApi.isCainiao(appId)) {
            return cainiaoApi.getRequestCredits(request);
        }
        if (isYouku(appId)) {
            return youkuApi.getSubCreditsMessage(request);
        }
        if (isTaopiaopiao(appId)) {
            return taopiaopiaoApi.getSubCreditsMessage(request);
        }
        if(isHaiDiLao(appId)){
           return haidilaoApi.getSubCreditsMessage(request);
        }
        if(isWeibo(appId)){
            return weiboApi.getSubCreditsMessage(request);
        }
        if(isSohuZiXun(appId)){
            return sohuzixunApi.getSubCreditsMessage(request);
        }
        return request;
    }

    @Override
    public SubCreditsMsgWrapper getRequestCredits(SubCreditsMsgWrapper subCreditsMsgWrapper) {
        if (subCreditsMsgWrapper.getSubCreditsMsg().getAppId() == null) {
            return subCreditsMsgWrapper;
        }
        Long appId = Long.valueOf(subCreditsMsgWrapper.getSubCreditsMsg().getAppId());
        if (isMogujie(appId)) {
            return mogujieApi.getMogujieRequestCredits(subCreditsMsgWrapper);
        }
        if (isPajk(appId)) {
            return pajkApi.getPajkRequestCredits(subCreditsMsgWrapper);
        }
        if (isTaojinbi(appId)) {
            return taojinbiApi.getCreditsMessage(subCreditsMsgWrapper);
        }
        if(isMobike(appId)){
            return mobikeApi.buildSubCreditsRequest(subCreditsMsgWrapper);
        }
        if (isFengJin(appId)) {
            return fengJinApi.getSubCreditsMessage(subCreditsMsgWrapper);
        }
        if (isIqiyi(appId)) {
            return iqiyiApi.getSubCreditsMessage(subCreditsMsgWrapper);
        }
        if (CainiaoApi.isCainiao(appId)) {
            return cainiaoApi.getRequestCredits(subCreditsMsgWrapper);
        }
        if (isYouku(appId)) {
            return youkuApi.getRequestCredits(subCreditsMsgWrapper);
        }
        if(isHaiDiLao(appId)){
            return haidilaoApi.getRequestCredits(subCreditsMsgWrapper);
        }
        if(isWeibo(appId)){
            return weiboApi.getRequestCredits(subCreditsMsgWrapper);
        }
        if(isSohuZiXun(appId)){
            return sohuzixunApi.getSubCreditsMessage(subCreditsMsgWrapper);
        }
        return subCreditsMsgWrapper;
    }

    @Override
    public String getResponseCredits(Long appId, String body) {
        if (appId == null) {
            return body;
        }
        HttpRequestLog.logUrl("[action subCredits] [tag response] [appId " + appId + "] [type completed] [body " + body + "]");
        if (isMogujie(appId)) {
            return mogujieApi.getMogujieResponseCredis(body);
        }
        if (isPajk(appId)) {
            return pajkApi.getPajkResponseCredits(appId, body);
        }
        if (isTaojinbi(appId)) {
            return taojinbiApi.parseCreditsRsp(body);
        }
        if (CainiaoApi.isCainiao(appId)) {
            return cainiaoApi.parseCreditsRsp(body);
        }
        if (isYouku(appId)) {
            return youkuApi.parseCreditsRsp(body);
        }
        if (isTaopiaopiao(appId)) {
            return taopiaopiaoApi.parseCreditsRsp(body);
        }
        if (isSohuZiXun(appId)) {
            return sohuzixunApi.parseCreditsRsp(body);
        }
//        if(isHaiDiLao(appId)){
//            return haidilaoApi.parseCreditsRsp(body);
//        }

        return body;
    }

    @Override
    public HttpRequestBase getRequestNotify(String notifyUrl, NotifyQueueDO record,String time, AppDO appDO, CreditNotifyParams params) {
        try {
            if (isMogujie(record.getAppId())) {
                return mogujieApi.getMogujieRequestNotify(notifyUrl, record);
            }
            if (isPajk(record.getAppId())) {
                return pajkApi.getPajkRequestNotify(notifyUrl, record);
            }
            if(isMobike(record.getAppId())){
                return mobikeApi.getMobikeNotifyUrl(notifyUrl,record,time);
            }
            if (isFengJin(record.getAppId())) {
                return fengJinApi.getRequestNotify(notifyUrl, record, appDO);
            }
            if (isIqiyi(record.getAppId())) {
                return iqiyiApi.getRequestNotify(notifyUrl, record);
            }
            if(isCainiao(record.getAppId())){
                return cainiaoApi.getRequestNotify(notifyUrl, record, appDO, params);
            }
            if (isYouku(record.getAppId())) {
                return youkuApi.getRequestNotify(notifyUrl,record);
            }
            if(isHaiDiLao(record.getAppId())){
                return haidilaoApi.getRequestNotify(notifyUrl, record, appDO, params);
            }
            if(isSohuZiXun(record.getAppId())){
                return sohuzixunApi.getRequestNotify(notifyUrl, record);
            }
            return null;

        } catch (Exception e) {
            log.error("getRequestNotify", e.getMessage());
            throw new IllegalStateException("notify error", e);
        }
    }

    @Override
    public String getResponseNotify(Long appId, String body) {
        try {
            if (isMogujie(appId)) {
                HttpRequestLog.logUrl("[action notify] [tag response] [appId " + appId + "] [type completed] [body " + body + "]");
                return mogujieApi.getMogujieResponseNotify(body);
            }
            if (isPajk(appId)) {
                HttpRequestLog.logUrl("[action notify] [tag response] [appId " + appId + "] [type completed] [body " + body + "]");
                return pajkApi.getPajkResponseNotify(body);
            }
            if(isSohuZiXun(appId)){
                HttpRequestLog.logUrl("[action notify] [tag response] [appId " + appId + "] [type completed] [body " + body + "]");
                return sohuzixunApi.getSohuZixunResponseNotify(body);
            }
        } catch (Exception e) {
            log.error("getResponseNotify", e);
        }
        return body;
    }

    @Override
    public boolean isNotifyWithTransfer(Long appId) {
        return NOTIFY_WITH_TRANSFER.contains(appId);
    }

    @Override
    public Map<String, String> toRequestMapWithTransfer(String appSecret, CreditNotifyParams p, String transfer, String uid) {//uid没有get方法
        HashMap map = new HashMap();
        map.put("success", Boolean.toString(p.isSuccess()));
        map.put("errorMessage", getString(p.getErrorMessage()));
        map.put("bizId", getString(p.getBizId()));
        map.put("appKey", getString(p.getAppKey()));
        map.put("appSecret", getString(appSecret));
        map.put("timestamp", getString(Long.valueOf(p.getTimestamp().getTime())));
        map.put("uid", getString(uid));
        map.put("orderNum", getString(p.getOrderNum()));
        map.put("transfer", getString(transfer));
        String sign = SignTool.sign(map);
        map.remove("appSecret");
        map.put("sign", sign);
        return map;
    }

    private String getString(Object o) {
        return o == null ? "" : o.toString();
    }

	@Override
	public SupplierRequest getVirturalRequest(SupplierRequest request) {
		if(request.getAppId() == null){
			return request;
		}
		//如果是蘑菇街的魔豆
        Long appId=Long.valueOf(request.getAppId());
		if(isMogujie(appId)){
			return mogujieApi.getMogujieRequestSendCredits(request);
		}
		if(isMobike(appId)){
            return mobikeApi.getVirtualRequest(request);
        }
        if(isIqiyi(appId)){
            return iqiyiApi.getVirtualRequest(request);
        }
        if(isAliTrip(appId)){
            return aliTripApi.getVirtualRequest(request);
        }
        if(isHaiDiLao(appId)){
		    return haidilaoApi.getVirtualRequest(request);
        }
        if(isYouku(appId)){
            return youkuApi.getVirtualRequest(request);
        }
        if(isWeibo(appId)){
            return weiboApi.getVirtualRequest(request);
        }
		return request;
	}

	@Override
	public String getVirturalResponse(SupplierRequest message, String body) {
		if(message.getAppId() == null){
			return body;
		}
		//蘑菇街魔豆,以后有扩展还需要进一步划分
        Long appId=Long.valueOf(message.getAppId());
		if(isMogujie(appId)){
			return mogujieApi.getVirtualRespone(body);
		}
        if(isIqiyi(appId)){
            return iqiyiApi.getVirtualRespone(body);
        }
        if(isAliTrip(appId)){
            return aliTripApi.getVirtualRespone(body);
        }
        if(isHaiDiLao(appId)){
		    return haidilaoApi.getVirtualRespone(message,body);
        }
        if(isYouku(appId)){
            return youkuApi.getVirtualRespone(body);
        }
		return body;
	}

    @Override
    public HttpRequestBase getCrecordHttpRequest(HttpRequestMessageDto msg, AppDO app) {
        if(app != null && isCainiao(app.getId())){
            return cainiaoApi.getCrecordNotify(msg, app);
        }
        return null;
    }

    @Override
    public CreditsMessageDto getRequestAddCredits(CreditsMessageDto request) {
        if (request.getAppId() == null) {
            return request;
        }
        Long appId = Long.valueOf(request.getAppId());
        if (isTaopiaopiao(appId)) {
            return taopiaopiaoApi.getAddCreditsMessage(request);
        }
        if (isPajk(appId)) {
            return pajkApi.getAddCreditsMessage(request);
        }
        if(isHaiDiLao(appId)){
            return haidilaoApi.getAddCreditsMessage(request);
        }
        if(isWeibo(appId)){
            return weiboApi.getAddCreditsMessage(request);
        }
        return request;
    }

    @Override
    public void setHaidilaoSubAndAddHttpHeader(CreditsMessage request, HttpRequestBase http) {
        haidilaoApi.setHttpHeader(request,http,true);
    }

    @Override
    public HttpRequestBase  setHaidilaoVirtualHttpHeader(SupplierRequest message,HttpRequestBase http) {
       return haidilaoApi.setHaidilaoVirtualHttpHeader(message,http);
    }

    @Override
    public boolean isPostApp(Long appId) {
        return null != appId && usePostAppIds.contains(appId);
    }
}
