package cn.com.duiba.service.impl;

import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.mq.RocketMQMsgProducer;
import cn.com.duiba.service.DevAppTrustConfService;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.thirdparty.enums.HttpRequestResultType;
import cn.com.duiba.thirdparty.mq.msg.ValidatePrizeTagMsg;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.HttpRequestLog;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by ChenXiangge on 23/05/2018.
 */
@Service
public class DevAppTrustConfServiceImpl implements DevAppTrustConfService {

    private static final Logger LOGGER = LoggerFactory.getLogger(DevAppTrustConfServiceImpl.class);

    @Autowired
    private HttpAsyncClientPool httpAsyncClientPool;

    @Autowired
    private RocketMQMsgProducer rocketMQMsgProducer;

    @Override
    public void sendDevPrizeTagMsg(ValidatePrizeTagMsg validatePrizeTagMsg) {
        //组装http请求
        if (validatePrizeTagMsg == null) {
            return;
        }
        Map<String, String> param = new HashMap<>();
        param.put("uid", String.valueOf(validatePrizeTagMsg.getUid()));
        param.put("actId", String.valueOf(validatePrizeTagMsg.getActId()));
        param.put("prizeMark", validatePrizeTagMsg.getPrizeMark());
        param.put("appKey", validatePrizeTagMsg.getAppKey());
        param.put("timestamp", String.valueOf(System.currentTimeMillis()));
        param.put("appSecret", validatePrizeTagMsg.getAppSecret());
        param.put("sign", SignTool.sign(param));

        //传给开发者参数去掉appSecret
        param.remove("appSecret");

        final String httpUrl = AssembleTool.assembleUrl(validatePrizeTagMsg.getApiUrl(), param);
        LOGGER.info("访问开发者信用接口url {}", httpUrl);

        HttpRequestBase http = new HttpGet(httpUrl);

        httpAsyncClientPool.submit(String.valueOf(validatePrizeTagMsg.getAppid()), http, new FutureCallback<HttpResponse>() {
            @Override
            public void completed(HttpResponse result) {
                try {
                    validatePrizeTagMsg.setResultType(HttpRequestResultType.COMPLETED);
                    String body = EntityUtils.toString(result.getEntity());
                    //获取开发者结果
                    parseResponseBody(body, validatePrizeTagMsg);
                } catch (Exception e) {
                    LOGGER.error("visit developer api failed", e);

                } finally {
                    finallyBlock(validatePrizeTagMsg, validatePrizeTagMsg.getCallbackTopic(), validatePrizeTagMsg.getCallbackTag(), validatePrizeTagMsg.getCallbackKey(), "");
                }
            }

            @Override
            public void failed(Exception ex) {
                try {
                    validatePrizeTagMsg.setResultType(HttpRequestResultType.FAILED);
                    //调用开发者接口失败 - 发奖
                    validatePrizeTagMsg.setGivePrize(1);
                } catch (Exception e) {
                    LOGGER.error("visit developer api failed", e);
                } finally {
                    finallyBlock(validatePrizeTagMsg, validatePrizeTagMsg.getCallbackTopic(), validatePrizeTagMsg.getCallbackTag(), validatePrizeTagMsg.getCallbackKey(), "");
                }
            }

            @Override
            public void cancelled() {
                try {
                    validatePrizeTagMsg.setResultType(HttpRequestResultType.CANCELLED);
                    //调用开发者接口失败 - 发奖
                    validatePrizeTagMsg.setGivePrize(1);
                } catch (Exception e) {
                    LOGGER.error("visit developer api failed", e);
                } finally {
                    finallyBlock(validatePrizeTagMsg, validatePrizeTagMsg.getCallbackTopic(), validatePrizeTagMsg.getCallbackTag(), validatePrizeTagMsg.getCallbackKey(), "");
                }
            }
        });
    }

    private void parseResponseBody(String body, ValidatePrizeTagMsg resultMsg) {
        LOGGER.info("访问开发者信用接口返回结果 {}", body);
        try {
            JSONObject bodyJson = JSON.parseObject(body);
            boolean isSuccess = bodyJson.getBoolean("success");
            if (isSuccess) {
                JSONObject data = bodyJson.getJSONObject("data");
                Integer givePrize = data.getInteger("givePrize");
                resultMsg.setGivePrize(givePrize);
            }
        } catch (Exception e) {
            LOGGER.warn("parse ValidatePrizeTagMsg json fail, appId={}, body={}", resultMsg.getAppid(), body);
            resultMsg.setGivePrize(1);
        }
    }

    /**
     * 返回响应结果到业务方
     *
     * @param resp
     * @param msgTopic
     * @param msgTag
     * @param msgKey
     */
    private void finallyBlock(ValidatePrizeTagMsg resp, String msgTopic, String msgTag, String msgKey, String code) {
        String body = null;
        try {
            body = JSON.toJSONString(resp);
            rocketMQMsgProducer.sendMsg(msgTopic, msgTag, msgKey, body, false, null);
        } catch (Exception e) {
            LOGGER.error("validatePrizeTag callback: appid:" + resp.getAppid() + " apiUrl:" + resp.getApiUrl(), e);
        } finally {
            HttpRequestLog.logUrl("[action validatePrizeTag] [tag response] [code " + code + "] [appid " + resp.getAppid() +
                    "] [apiUrl " + resp.getApiUrl() + "] [body " + body + "]");
        }

    }
}
