package cn.com.duiba.service.impl;

import cn.com.duiba.biz.tool.duiba.mq.EmailMsg;
import cn.com.duiba.service.EmailService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;

import javax.mail.internet.MimeMessage;
import java.util.concurrent.ExecutorService;


@Service
public class EmailServiceImpl implements EmailService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmailServiceImpl.class);
    @Autowired
    private JavaMailSender javaMailSender;

    @Autowired
    private ExecutorService executorService;

    @Override
    public void sendEmail(EmailMsg emailMsg) {
        executorService.execute(() -> {
            try {
                MimeMessage mimeMessage = javaMailSender.createMimeMessage();
                MimeMessageHelper helper = new MimeMessageHelper(mimeMessage);
                helper.setTo(emailMsg.getReceiver()); // 发送给谁
                helper.setSubject(emailMsg.getSubject()); // 标题
                helper.setFrom("system@duiba.com.cn"); // 来自
                // 邮件内容，第二个参数指定发送的是HTML格式
                helper.setText(emailMsg.getHtml(), true);
                javaMailSender.send(mimeMessage);
            } catch (Exception e) {
                LOGGER.error("sendEmail failed, receiver={}, subject={}", emailMsg.getReceiver(), emailMsg.getSubject(), e);
            }
        });
    }
}
