package cn.com.duiba.service.impl;

import cn.com.duiba.dao.SaasDevFreeDAO;
import cn.com.duiba.service.SaasDevFreeService;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.util.concurrent.TimeUnit;

/**
 * Created by fangdong on 2018/10/19
 */
@Service("saasDevFreeService")
public class SaasDevFreeServiceImpl implements SaasDevFreeService {
    private static final Logger log = LoggerFactory.getLogger(SaasDevFreeServiceImpl.class);

    private static Cache<Long, Boolean> saasDevFreeCache = CacheBuilder.newBuilder().maximumSize(1000)
            .expireAfterWrite(1, TimeUnit.MINUTES).build();

    @Resource
    private SaasDevFreeDAO saasDevFreeDAO;

    @Override
    public Boolean isExists(Long developerId) {
        Assert.notNull(developerId, "developerId不能为null");
        try {
            return saasDevFreeCache.get(developerId,() -> isExistsInternal(developerId));
        } catch (Exception e) {
            log.error("saasDevFreeService.isExists Cache error", e);
            return isExistsInternal(developerId);
        }
    }

    private Boolean isExistsInternal(Long developerId) {
        return saasDevFreeDAO.countByDeveloperId(developerId) != 0L;
    }

}
