/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.credits.sdk.CreditNotifyParams;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.tool.AssembleTool;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class Receipt360Api {
    private static final Logger LOGGER = LoggerFactory.getLogger(Receipt360Api.class);
    @Autowired
    private AppDAO appDAO;

    public SubCreditsMsgWrapper getSubCreditsMessage(SubCreditsMsgWrapper subCreditsMsgWrapper) {
        String encodeUrl = this.generateTwiceEncodeUrl(subCreditsMsgWrapper.getHttpUrl());
        subCreditsMsgWrapper.setHttpUrl(encodeUrl);
        return subCreditsMsgWrapper;
    }

    public CreditsMessage getSubCreditsMessage(CreditsMessage creditsMessage) {
        String encodeUrl = this.generateTwiceEncodeUrl(creditsMessage.getHttpUrl());
        creditsMessage.setHttpUrl(encodeUrl);
        return creditsMessage;
    }

    private String generateTwiceEncodeUrl(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return url;
        }
        String host = url.substring(0, url.indexOf(63));
        String params = url.substring(url.indexOf(63) + 1);
        Map<String, String> paramMap = AssembleTool.getUrlParams(params);
        return AssembleTool.assembleUrlEncodeTwice(host, paramMap);
    }

    public HttpRequestBase getRequestNotify(NotifyQueueDO record, AppDO app, CreditNotifyParams p) {
        HashMap<String, String> map = new HashMap<String, String>();
        String transfer = record.getTransfer();
        if (StringUtils.isNotBlank((CharSequence)transfer)) {
            map.put("success", Boolean.toString(p.isSuccess()));
            map.put("errorMessage", this.getString(p.getErrorMessage()));
            map.put("bizId", this.getString(p.getBizId()));
            map.put("appKey", this.getString(p.getAppKey()));
            map.put("appSecret", this.getString(this.appDAO.getAppSecret(app)));
            map.put("timestamp", this.getString(p.getTimestamp().getTime()));
            map.put("uid", this.getString(record.getPartnerUserId()));
            map.put("orderNum", this.getString(p.getOrderNum()));
            map.put("transfer", this.getString(transfer));
            String sign = SignTool.sign(map);
            map.remove("appSecret");
            map.put("sign", sign);
        } else {
            map = p.toRequestMap(this.appDAO.getAppSecret(app));
        }
        HttpGet http = new HttpGet(AssembleTool.assembleUrlEncodeTwice(app.getCreditsConsumeNotifyUrl(), map));
        return http;
    }

    private String getString(Object o) {
        return o == null ? "" : o.toString();
    }
}

