/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits;

import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.JsonTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpRequestBase;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Deprecated
public class SohuzixunApi {
    private static Logger logger = LoggerFactory.getLogger(SohuzixunApi.class);
    private static final String SOHUZIXUN_APPKEY = "VGYUMUSM5GMF7kEJkmhrPsMWXntS";
    private static final String SOHUZIXUN_APPSECRET = "WUwsSSNJAARLu57C1jBTTXIyDmgF";
    private static final String CONSUME_CREDITS = "consume_credits";
    private static final String RESULT_NOTICE = "result_notice";
    private static final String DELIMITER = "?";
    private static final String POSTTYPE = "postType";
    private static final String RAW = "raw";

    public CreditsMessage getSubCreditsMessage(@Nonnull CreditsMessage request) {
        String url = request.getHttpUrl();
        String host = this.getGateway(url);
        String urlParams = url.substring(url.indexOf(63) + 1, url.length());
        Map<String, String> creditsMap = AssembleTool.getUrlParams(urlParams);
        Map<String, String> authParams = this.bulidParms(creditsMap, null, CONSUME_CREDITS);
        request.setAuthParams(authParams);
        request.setHttpType("post");
        request.setHttpUrl(host);
        return request;
    }

    public SubCreditsMsgWrapper getSubCreditsMessage(SubCreditsMsgWrapper request) {
        String url = request.getHttpUrl();
        String host = url.substring(0, url.indexOf(63));
        String urlParams = url.substring(url.indexOf(63) + 1, url.length());
        Map<String, String> creditsMap = AssembleTool.getUrlParams(urlParams);
        Map<String, String> authParams = this.bulidParms(creditsMap, null, CONSUME_CREDITS);
        request.getSubCreditsMsg().setAuthParams(authParams);
        request.getSubCreditsMsg().setHttpType(2);
        request.setHttpUrl(host);
        return request;
    }

    public HttpRequestBase getRequestNotify(String notifyUrl, NotifyQueueDO record) {
        Map<String, String> paramsMap = this.bulidParms(null, record, RESULT_NOTICE);
        return AssembleTool.assembleRequest(notifyUrl, paramsMap);
    }

    public String parseCreditsRsp(String body) {
        try {
            JSONObject jsonBody = JSON.parseObject((String)body);
            JSONObject json = JsonTool.getAllJson(jsonBody);
            HashMap<String, String> duibaDoc = new HashMap<String, String>();
            String errorCode = json.getString("errorCode");
            if ("0".equals(errorCode)) {
                duibaDoc.put("status", "ok");
                duibaDoc.put("bizId", json.getString("bizId"));
                duibaDoc.put("credits", json.getString("number"));
            } else {
                duibaDoc.put("status", "fail");
            }
            duibaDoc.put("errorMessage", json.getString("message"));
            return JsonTool.objectToJson(duibaDoc);
        }
        catch (Exception e) {
            logger.error("[SohuzixunApi-parseCreditsRsp]\u641c\u72d0\u8d44\u8baf\u6263\u79ef\u5206\u8bf7\u6c42\u5f02\u5e38\uff0c\u54cd\u5e94\u89e3\u6790\u51fa\u9519:{}", (Throwable)e);
            return body;
        }
    }

    public String getSohuZixunResponseNotify(String body) {
        try {
            JSONObject jsonBody = JSON.parseObject((String)body);
            JSONObject json = JsonTool.getAllJson(jsonBody);
            String code = json.getString("errorCode");
            if ("0".equals(code)) {
                return "ok";
            }
            return "fail";
        }
        catch (Exception e) {
            logger.error("[SohuzixunApi-parseCreditsRsp]\u641c\u72d0\u8d44\u8baf\u7ed3\u679c\u901a\u77e5\u8bf7\u6c42\u5f02\u5e38\uff0c\u54cd\u5e94\u89e3\u6790\u51fa\u9519:{}", (Throwable)e);
            return body;
        }
    }

    private Map<String, String> bulidParms(Map<String, String> params, NotifyQueueDO record, String signLogo) {
        Map<Object, Object> paramsMap = Maps.newHashMap();
        if (signLogo.equals(CONSUME_CREDITS)) {
            paramsMap = this.splitTransfer(params.get("transfer"));
            paramsMap.put("userId", params.get("uid"));
            paramsMap.put("timestamp", String.valueOf(new Date().getTime()));
            paramsMap.put("addCoin", "-" + params.get("credits"));
            paramsMap.put("orderId", params.get("orderNum"));
        } else if (signLogo.equals(RESULT_NOTICE)) {
            paramsMap = this.splitTransfer(record.getTransfer());
            paramsMap.put("userId", String.valueOf(record.getPartnerUserId()));
            paramsMap.put("timestamp", String.valueOf(new Date().getTime()));
            paramsMap.put("orderId", record.getDuibaOrderNum());
            String auditResult = "0";
            if (record.getResult().booleanValue()) {
                auditResult = "1";
            }
            paramsMap.put("auditResult", auditResult);
        }
        paramsMap.put("appKey", SOHUZIXUN_APPKEY);
        paramsMap.put("appSecret", SOHUZIXUN_APPSECRET);
        paramsMap.put("sign", SignTool.sign(paramsMap));
        paramsMap.remove("appSecret");
        paramsMap.put(POSTTYPE, RAW);
        return paramsMap;
    }

    @Nullable
    private String getGateway(String url) {
        int index;
        if (StringUtils.isNotBlank((String)url) && (index = url.indexOf(DELIMITER)) != -1) {
            return url.substring(0, index);
        }
        return url;
    }

    private Map<String, String> splitTransfer(String transfer) {
        HashMap paramsMap = Maps.newHashMap();
        String toParams = null;
        try {
            toParams = URLDecoder.decode(transfer, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("sohuTransferURLDecoder.decode error:" + transfer, (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        String[] transfers = toParams.split("&");
        for (int i = 0; i < transfers.length; ++i) {
            String[] p = transfers[i].split("=");
            if (p.length != 2) continue;
            String key = p[0];
            String value = p[1];
            paramsMap.put(key, value);
        }
        return paramsMap;
    }
}

