/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.biz.credits.impl;

import cn.com.duiba.biz.credits.PinganCardApi;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.constant.PinganCardConfig;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.JsonTool;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PinganCardApiImpl
implements PinganCardApi {
    private static final Logger logger = LoggerFactory.getLogger(PinganCardApiImpl.class);
    private static final String RSA_KEY_ALGORITHM = "RSA";
    private static final String SIGNATURE_ALGORITHM = "MD5withRSA";
    private static final String DELIMITER = "?";
    @Autowired
    private PinganCardConfig pinganCardConfig;
    private static RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(2000).setConnectTimeout(2000).setSocketTimeout(2000).build();

    @Override
    public Boolean isPingan(Long appId) {
        return this.pinganCardConfig.getAppIds().contains(appId);
    }

    @Override
    public SupplierRequest getVirturalRequest(SupplierRequest request) {
        String url = request.getHttpUrl();
        List<String> analysisList = PinganCardApiImpl.analysisUrl(url);
        if (CollectionUtils.isEmpty(analysisList)) {
            return request;
        }
        String host = analysisList.get(0);
        Map<String, String> params = AssembleTool.getUrlParams(analysisList.get(1));
        String paramString = this.buildGiveGoldenCoinsParams(params.get("orderNum"), params.get("uid"), params.get("params"));
        request.setHttpUrl(host + DELIMITER + paramString);
        return request;
    }

    @Override
    public String getVirturalResponse(String body) {
        HashMap<String, String> duibaDoc = new HashMap<String, String>();
        try {
            String data = this.checkResponse(body);
            duibaDoc.put("status", "success");
            duibaDoc.put("data", data);
        }
        catch (Exception e) {
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", e.getMessage());
            logger.info("[PinganCardApiImpl-getVirturalResponse]\u5e73\u5b89\u5361\u4e2d\u5fc3-\u865a\u62df\u5546\u54c1\u8bf7\u6c42\u54cd\u5e94\u89e3\u6790\u5f02\u5e38:", (Throwable)e);
        }
        return JsonTool.objectToJson(duibaDoc);
    }

    private String checkResponse(String result) throws BizException {
        JSONObject resultJson = JSONObject.parseObject((String)result);
        if (null == resultJson) {
            throw new BizException("\u5e73\u5b89\u5361\u4e2d\u5fc3\u89e3\u6790\u8fd4\u56de\u4f53\u5931\u8d25");
        }
        if (!"000000".equals(resultJson.getString("responseCode"))) {
            logger.warn("\u5e73\u5b89\u5361\u4e2d\u5fc3\u53cc\u5341\u4e00\u5241\u624b \u53d1\u91d1\u5e01\u8fd4\u56de\u5931\u8d25\uff0c{}", (Object)resultJson.toJSONString());
            throw new BizException("\u91d1\u5e01\u53d1\u653e\u5f02\u5e38\uff1a" + resultJson);
        }
        return "\u53d1\u91d1\u5e01\u6210\u529f";
    }

    private String buildGiveGoldenCoinsParams(String outsourceId, String openId, String thirdActiviId) {
        StringBuilder stringBuilder = new StringBuilder();
        Long now = System.currentTimeMillis();
        String originalValue = now + openId + this.pinganCardConfig.getThirdPart() + thirdActiviId + outsourceId + this.pinganCardConfig.getInterfaceKey();
        String sign = DigestUtils.md5Hex((String)originalValue);
        String accessToken = null;
        int tokenFlag = 0;
        while (StringUtils.isBlank(accessToken)) {
            accessToken = this.getAccessToken();
            if (++tokenFlag < 4) continue;
            logger.warn("\u5e73\u5b89\u5361\u4e2d\u5fc3 \u53d1\u91d1\u5e01\u8fde\u7eed3\u6b21\u5931\u8d25\uff01");
            break;
        }
        stringBuilder.append("channel=").append(this.pinganCardConfig.getChannel()).append("&accessToken=").append(accessToken).append("&thirdPart=").append(this.pinganCardConfig.getThirdPart()).append("&sign=").append(sign).append("&timeStamp=").append(now).append("&outsourceId=").append(outsourceId).append("&openId=").append(openId).append("&activityCode=").append(thirdActiviId);
        return stringBuilder.toString();
    }

    private String getAccessToken() {
        StringBuilder stringBuilder = new StringBuilder();
        Double random = Math.random() * 10000.0;
        Long timestamp = System.currentTimeMillis();
        String data = this.pinganCardConfig.getChannel() + ";" + random.longValue() + ";" + timestamp;
        try {
            String sign = PinganCardApiImpl.sign(data.getBytes(), this.pinganCardConfig.getPrivateKey());
            stringBuilder.append(this.pinganCardConfig.getAccessTokenUrl()).append("channel=").append(this.pinganCardConfig.getChannel()).append("&random=").append(random.longValue()).append("&timestamp=").append(timestamp).append("&sign=").append(sign);
            JSONObject response = JSONObject.parseObject((String)PinganCardApiImpl.doGet(stringBuilder.toString()));
            return response.getString("accessToken");
        }
        catch (Exception e) {
            logger.warn("\u5e73\u5b89\u5361\u4e2d\u5fc3 \u53cc\u5341\u4e00\u5241\u624b \u751f\u6210\u516c\u94a5\u5931\u8d25\uff0c{}", (Object)data, (Object)e);
            return null;
        }
    }

    public static String sign(byte[] data, String pri_key) throws Exception {
        byte[] pri_key_bytes = Base64.decodeBase64((String)pri_key);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(pri_key_bytes);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_KEY_ALGORITHM);
        PrivateKey priKey = keyFactory.generatePrivate(pkcs8KeySpec);
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initSign(priKey);
        signature.update(data);
        return Base64.encodeBase64String((byte[])signature.sign());
    }

    public static String doGet(String url) throws Exception {
        CloseableHttpClient httpclient = HttpClients.custom().setDefaultRequestConfig(config).build();
        CloseableHttpResponse response = null;
        try {
            HttpGet httpget = new HttpGet(url);
            response = httpclient.execute((HttpUriRequest)httpget);
            if (response.getStatusLine().getStatusCode() == 200) {
                String string = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                return string;
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (null != response) {
                    response.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private static List<String> analysisUrl(String url) {
        ArrayList analysis = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)url)) {
            int index = url.indexOf(DELIMITER);
            if (index != -1) {
                analysis.add(url.substring(0, index));
                analysis.add(url.substring(index + 1, url.length()));
            } else {
                analysis.add(url);
                analysis.add("");
            }
        }
        return analysis;
    }
}

