/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.notifycenter.service;

import cn.com.duiba.biz.credits.CiticBankApi;
import cn.com.duiba.biz.credits.WjrcbApi;
import cn.com.duiba.service.SlowRequestHandler;
import cn.com.duiba.service.ThreadPoolService;
import cn.com.duiba.tool.UrlUtils;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.ttl.threadpool.TtlExecutors;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NotifyHttpClientPool
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(NotifyHttpClientPool.class);
    @Resource(name="httpAsyncNotifyClient")
    @CanAccessInsideNetwork
    private CloseableHttpAsyncClient httpClient;
    @Resource(name="citicBankHttpAsyncNotifyClient")
    @CanAccessInsideNetwork
    private CloseableHttpAsyncClient citicBankHttpAsyncNotifyClient;
    @Resource(name="citicBankXiAnHttpAsyncNotifyClient")
    @CanAccessInsideNetwork
    private CloseableHttpAsyncClient citicBankXiAnHttpAsyncNotifyClient;
    @Resource(name="wjrcbHttpAsyncNotifyClient")
    @CanAccessInsideNetwork
    private CloseableHttpAsyncClient wjrcbHttpAsyncNotifyClient;
    @Resource(name="slowHttpAsyncNotifyClient")
    @CanAccessInsideNetwork
    private CloseableHttpAsyncClient slowHttpAsyncNotifyClient;
    private Map<Long, AtomicInteger> runningStat = new ConcurrentHashMap<Long, AtomicInteger>();
    @Autowired
    private ThreadPoolService threadPoolService;
    @Autowired
    private SlowRequestHandler slowRequestHandler;
    @Autowired
    private CiticBankApi citicBankApi;
    @Autowired
    private WjrcbApi wjrcbApi;
    private final BlockingQueue<CallbackProcesser> latterNotifyQueue = new LinkedBlockingQueue<CallbackProcesser>(50000);
    private final ExecutorService executorService = TtlExecutors.getTtlExecutorService((ExecutorService)Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "LatterNotifyQueueProcess");
        }
    }));
    private volatile boolean started = true;

    private void execute(Long appId, HttpUriRequest request, FutureCallback<HttpResponse> callback, CloseableHttpAsyncClient httpClient) {
        try {
            long s = System.currentTimeMillis();
            AtomicInteger count = this.runningStat.get(appId);
            if (count == null) {
                count = new AtomicInteger(1);
                this.runningStat.put(appId, count);
            } else {
                count.incrementAndGet();
            }
            request.setHeader("User-Agent", "Mozilla/5.0 (iPhone; CPU iPhone OS 9_1 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13B143 Safari/601.1");
            CallbackProcesser process = new CallbackProcesser(appId, request, callback);
            String reqUrl = UrlUtils.buildUrl(request.getURI());
            if (this.slowRequestHandler.isBlackHost(reqUrl)) {
                log.info("{} is black host", (Object)reqUrl);
                return;
            }
            if (this.executeCustom(appId, httpClient, s, process, reqUrl)) {
                return;
            }
            if (this.slowRequestHandler.isSlow(reqUrl)) {
                log.info("url [{}], add to queue, appId={}", (Object)reqUrl, (Object)appId);
                this.slowRequestHandler.addQueue(process);
                return;
            }
            httpClient.execute(process.getRequest(), (FutureCallback)process);
            long e = System.currentTimeMillis();
            long t = e - s;
            if (t > 1000L) {
                log.warn("notify httpClent.execute > {}ms, url={}, appId={}", new Object[]{t, reqUrl, appId});
                if (t > 2000L) {
                    this.slowRequestHandler.addSlow(reqUrl, (int)(t / 1000L));
                }
            }
        }
        catch (Exception e) {
            callback.failed(e);
            log.error("execute:", (Throwable)e);
        }
    }

    private boolean executeCustom(Long appId, CloseableHttpAsyncClient httpClient, long s, CallbackProcesser process, String reqUrl) {
        if (this.citicBankApi.isCiticBank(appId) || this.citicBankApi.isXiAnApp(appId)) {
            httpClient.execute(process.getRequest(), (FutureCallback)process);
            long e = System.currentTimeMillis();
            long t = e - s;
            if (t > 1000L) {
                log.warn("notify httpClent.execute > {}ms, url={}, appId={}", new Object[]{t, reqUrl, appId});
            }
            return true;
        }
        return false;
    }

    public void submit(final Long appId, final HttpUriRequest request, final FutureCallback<HttpResponse> callback) {
        if (this.submitCustom(appId, request, callback)) {
            return;
        }
        if (this.threadPoolService.canSubmit()) {
            this.threadPoolService.submit(new Runnable(){

                @Override
                public void run() {
                    NotifyHttpClientPool.this.execute(appId, request, (FutureCallback<HttpResponse>)callback, NotifyHttpClientPool.this.httpClient);
                }
            });
        } else {
            try {
                this.latterNotifyQueue.add(new CallbackProcesser(appId, request, callback));
            }
            catch (IllegalStateException e) {
                log.warn("latterNotifyQueue is temporarily full", (Throwable)e);
                callback.cancelled();
            }
        }
    }

    private boolean submitCustom(Long appId, HttpUriRequest request, FutureCallback<HttpResponse> callback) {
        CloseableHttpAsyncClient customHttpClient = this.getCustomHttpClient(appId);
        if (customHttpClient != null) {
            if (this.threadPoolService.canSubmit()) {
                this.threadPoolService.submit(() -> this.execute(appId, request, callback, customHttpClient));
            } else {
                this.execute(appId, request, callback, customHttpClient);
            }
            return true;
        }
        return false;
    }

    private CloseableHttpAsyncClient getCustomHttpClient(Long appId) {
        if (this.citicBankApi.isCiticBank(appId)) {
            return this.citicBankHttpAsyncNotifyClient;
        }
        if (this.citicBankApi.isXiAnApp(appId)) {
            return this.citicBankXiAnHttpAsyncNotifyClient;
        }
        if (this.wjrcbApi.isWjrcb(appId)) {
            return this.wjrcbHttpAsyncNotifyClient;
        }
        return null;
    }

    public JSONObject dumpDetail() {
        HashMap<Long, AtomicInteger> map = new HashMap<Long, AtomicInteger>();
        for (Map.Entry<Long, AtomicInteger> entry : this.runningStat.entrySet()) {
            if (entry.getValue().intValue() <= 0) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        JSONObject o = new JSONObject();
        o.put("runningStat", map);
        return o;
    }

    public int dumpSize() {
        int total = 0;
        for (AtomicInteger a : this.runningStat.values()) {
            total += a.get();
        }
        return total;
    }

    public void afterPropertiesSet() throws Exception {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                while (NotifyHttpClientPool.this.started) {
                    try {
                        if (!NotifyHttpClientPool.this.threadPoolService.canSubmit()) {
                            TimeUnit.MILLISECONDS.sleep(200L);
                            continue;
                        }
                        CallbackProcesser callbackProcesser = (CallbackProcesser)NotifyHttpClientPool.this.latterNotifyQueue.take();
                        final Long appId = callbackProcesser.getAppId();
                        final HttpUriRequest request = callbackProcesser.getRequest();
                        final FutureCallback callback = callbackProcesser.callback;
                        NotifyHttpClientPool.this.threadPoolService.submit(new Runnable(){

                            @Override
                            public void run() {
                                NotifyHttpClientPool.this.execute(appId, request, (FutureCallback<HttpResponse>)callback, NotifyHttpClientPool.this.slowHttpAsyncNotifyClient);
                            }
                        });
                    }
                    catch (InterruptedException e) {
                        log.warn("Interrupted", (Throwable)e);
                    }
                    catch (Exception e) {
                        log.warn("", (Throwable)e);
                    }
                }
            }
        });
    }

    public void destroy() throws Exception {
        this.started = false;
        this.executorService.shutdown();
    }

    public class CallbackProcesser
    implements FutureCallback<HttpResponse> {
        private HttpUriRequest request;
        private FutureCallback<HttpResponse> callback;
        private Long appId;

        public CallbackProcesser(Long appId, HttpUriRequest request, FutureCallback<HttpResponse> callback) {
            this.request = request;
            this.callback = callback;
            this.appId = appId;
        }

        public void completed(HttpResponse result) {
            try {
                CatUtils.executeInCatTransaction(() -> {
                    this.callback.completed((Object)result);
                    return null;
                }, (String)"AsyncHttp", (String)"completed");
            }
            catch (Throwable te) {
                log.error("completed;", te);
            }
            finally {
                ((AtomicInteger)NotifyHttpClientPool.this.runningStat.get(this.appId)).decrementAndGet();
            }
        }

        public void failed(Exception ex) {
            try {
                CatUtils.executeInCatTransaction(() -> {
                    this.callback.failed(ex);
                    return null;
                }, (String)"AsyncHttp", (String)"failed");
            }
            catch (Throwable te) {
                log.error("failed;", te);
            }
            finally {
                ((AtomicInteger)NotifyHttpClientPool.this.runningStat.get(this.appId)).decrementAndGet();
            }
        }

        public void cancelled() {
            try {
                CatUtils.executeInCatTransaction(() -> {
                    this.callback.cancelled();
                    return null;
                }, (String)"AsyncHttp", (String)"cancelled");
            }
            catch (Throwable te) {
                log.error("cancelled;", te);
            }
            finally {
                ((AtomicInteger)NotifyHttpClientPool.this.runningStat.get(this.appId)).decrementAndGet();
            }
        }

        public HttpUriRequest getRequest() {
            return this.request;
        }

        public Long getAppId() {
            return this.appId;
        }
    }
}

