/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.impl;

import cn.com.duiba.dao.AppNewExtraDao;
import cn.com.duiba.service.AccessAcountService;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class AccessAcountServiceImpl
implements AccessAcountService {
    private static final Logger log = LoggerFactory.getLogger(AccessAcountServiceImpl.class);
    private static Cache<Long, Boolean> accessAcountCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.MINUTES).build();
    @Autowired
    private AppNewExtraDao appNewExtraDao;

    @Override
    public Boolean canAccessAcount(Long appId) {
        Assert.notNull((Object)appId, (String)"appId\u4e0d\u80fd\u4e3anull");
        try {
            return (Boolean)accessAcountCache.get((Object)appId, () -> this.isExistsInternal(appId));
        }
        catch (Exception e) {
            log.error("canAccessAcount Cache error appid={}", (Object)appId, (Object)e);
            return this.isExistsInternal(appId);
        }
    }

    private Boolean isExistsInternal(Long appId) {
        String statu = this.appNewExtraDao.findAccessAccountStatus(appId);
        return StringUtils.equals((CharSequence)statu, (CharSequence)"on");
    }
}

