/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tool.sn;

import cn.com.duiba.tool.sn.SMS4;
import java.io.UnsupportedEncodingException;

public class SMS4Util {
    public static byte[] encodeSMS4(String plaintext, byte[] key) {
        if (plaintext == null || plaintext.equals("")) {
            return null;
        }
        for (int i = plaintext.getBytes().length % 16; i < 16; ++i) {
            plaintext = plaintext + "\u0000";
        }
        return SMS4Util.encodeSMS4(plaintext.getBytes(), key);
    }

    public static byte[] encodeSMS4(byte[] plaintext, byte[] key) {
        byte[] ciphertext = new byte[plaintext.length];
        int k = 0;
        int plainLen = plaintext.length;
        while (k + 16 <= plainLen) {
            byte[] cellPlain = new byte[16];
            for (int i = 0; i < 16; ++i) {
                cellPlain[i] = plaintext[k + i];
            }
            byte[] cellCipher = SMS4Util.encode16(cellPlain, key);
            for (int i = 0; i < cellCipher.length; ++i) {
                ciphertext[k + i] = cellCipher[i];
            }
            k += 16;
        }
        return ciphertext;
    }

    public static byte[] decodeSMS4(byte[] ciphertext, byte[] key) {
        byte[] plaintext = new byte[ciphertext.length];
        int k = 0;
        int cipherLen = ciphertext.length;
        while (k + 16 <= cipherLen) {
            byte[] cellCipher = new byte[16];
            for (int i = 0; i < 16; ++i) {
                cellCipher[i] = ciphertext[k + i];
            }
            byte[] cellPlain = SMS4Util.decode16(cellCipher, key);
            for (int i = 0; i < cellPlain.length; ++i) {
                plaintext[k + i] = cellPlain[i];
            }
            k += 16;
        }
        return plaintext;
    }

    public static String decodeSMS4toString(byte[] ciphertext, byte[] key) {
        byte[] plaintext = SMS4Util.decodeSMS4(ciphertext, key);
        String plain = new String(plaintext);
        return plain.trim();
    }

    private static byte[] encode16(byte[] plaintext, byte[] key) {
        byte[] cipher = new byte[16];
        SMS4 sm4 = new SMS4();
        int ENCRYPT = 1;
        sm4.sms4(plaintext, 16, key, cipher, ENCRYPT);
        return cipher;
    }

    private static byte[] decode16(byte[] ciphertext, byte[] key) {
        byte[] plain = new byte[16];
        SMS4 sm4 = new SMS4();
        int DECRYPT = 0;
        sm4.sms4(ciphertext, 16, key, plain, DECRYPT);
        return plain;
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        byte[] key = new byte[]{1, 35, 69, 103, -119, -85, -51, -17, -2, -36, -70, -104, 118, 84, 50, 16};
        System.out.println(new String(key));
        String newString = "Coding1231";
        byte[] enOut = SMS4Util.encodeSMS4(newString, key);
        if (enOut == null) {
            return;
        }
        System.out.println("\u52a0\u5bc6\u7ed3\u679c\uff1a" + new String(enOut));
        byte[] deOut = SMS4Util.decodeSMS4(enOut, key);
        System.out.println("\u89e3\u5bc6\u7ed3\u679c(return byte[])" + new String(deOut));
        String deOutStr = SMS4Util.decodeSMS4toString(enOut, key);
        System.out.println("\u89e3\u5bc6\u7ed3\u679c(return String)\uff1a" + deOutStr);
    }
}

