package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.constant.LenovoConfig;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.thirdparty.dto.HttpRequestMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.HttpRequestLog;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.zjtlcb.fcloud.utils.MD5Util;
import com.zjtlcb.fcloud.utils.SM2Util;
import com.zjtlcb.fcloud.utils.SM3Util;
import com.zjtlcb.fcloud.utils.SM4Util;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/**
 * @author chenhang
 * @date 2021/7/22 11:47 上午
 */
@Service
public class LenovoApiStrategy implements ApiStrategy {
    private static Logger logger = LoggerFactory.getLogger(LenovoApiStrategy.class);

    @Autowired
    private AppDAO appDAO;
    @Autowired
    private LenovoConfig lenovoConfig;

    @Override
    public boolean isCustomCrecord(HttpRequestMessageDto dto) {
        String orderNum = dto.getHttpParams().get("orderNum");
        return StringUtils.isNotBlank(orderNum);
    }

    @Override
    public HttpRequestBase getCrecordNotify(HttpRequestMessageDto msg, AppDO app) {
        logger.info("联想兑换记录开始 appId:{}",app.getId());
        Map<String, String> params = msg.getHttpParams();
        params.put("appKey", app.getAppKey());
        params.put("appSecret", appDAO.getAppSecret(app));
        String sign = SignTool.sign(params);
        params.put("sign", sign);
        params.remove("appSecret");

        String url = lenovoConfig.getCrecordNotifyUrl();
        if(StringUtils.isBlank(url)){
            throw new ThirdpatyException("联想兑换记录同步url is not config");
        }
        logger.info("联想兑换记录请求参数 appId:{},params:{}",app.getId(),JSON.toJSONString(params));

        List<NameValuePair> pairs = new ArrayList<>(params.size());
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String value = entry.getValue();
            if (value != null) {
                pairs.add(new BasicNameValuePair(entry.getKey(), value));
            }
        }

        HttpPost post = new HttpPost(url);
        post.setEntity(new UrlEncodedFormEntity(pairs, StandardCharsets.UTF_8));
        post.addHeader("Content-Type", "application/x-www-form-urlencoded; text/html; charset=utf-8");
        return post;
    }


    @Override
    public String getCrecordResponse(String body) {
        logger.info("联想定制同步兑换记录响应, request={}",body);
        return getResponseNotify(body);
    }

}
