package cn.com.duiba.constant;

import com.google.common.collect.Sets;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Set;

/**
 * @author XuJing
 * @since 2020/4/17 10:21 上午
 * 港中旅酒店定制配置
 */
@Configuration
@ConfigurationProperties(prefix = "gangzhonglv")
public class GangZhongLvConfig {
    private Set<Long> appIds = Sets.newHashSet(1L);

    /**
     * 加积分相关参数
     */
    private String addUrl = "http://113.98.240.95:9001/siebel-rest/v1.0/service/MPH%20Member%20Points%20In%20Service/RedeemIn";
    private String addUserName ;
    private String addPassword ;
    private String addProductNo = "PANORA_Pro_02";

    /**
     * 扣积分相关参数
     */
    private String subProductNo = "PANORA_Pro_01";

    /**
     * 积分兑换相关参数
     */
    private String virtualPre = "db_";
    private String virtualCreditsPre = "dbcredits_";

    private String username ;

    private String password ;


    /**
     * 积分查询url
     *
     * @return
     */
    private String creditsSelectUrl = "http://113.98.240.95:10082/eai_chs/start.swe?SWEExtSource=WebService&SWEExtCmd=Execute&WSSOAP=1";

    public Set<Long> getAppIds() {
        return appIds;
    }

    public void setAppIds(Set<Long> appIds) {
        this.appIds = appIds;
    }

    public String getAddUrl() {
        return addUrl;
    }

    public void setAddUrl(String addUrl) {
        this.addUrl = addUrl;
    }

    public String getAddUserName() {
        return addUserName;
    }

    public void setAddUserName(String addUserName) {
        this.addUserName = addUserName;
    }

    public String getAddPassword() {
        return addPassword;
    }

    public void setAddPassword(String addPassword) {
        this.addPassword = addPassword;
    }

    public String getAddProductNo() {
        return addProductNo;
    }

    public void setAddProductNo(String addProductNo) {
        this.addProductNo = addProductNo;
    }

    public String getSubProductNo() {
        return subProductNo;
    }

    public void setSubProductNo(String subProductNo) {
        this.subProductNo = subProductNo;
    }

    public String getVirtualPre() {
        return virtualPre;
    }

    public void setVirtualPre(String virtualPre) {
        this.virtualPre = virtualPre;
    }

    public String getVirtualCreditsPre() {
        return virtualCreditsPre;
    }

    public void setVirtualCreditsPre(String virtualCreditsPre) {
        this.virtualCreditsPre = virtualCreditsPre;
    }

    public String getCreditsSelectUrl() {
        return creditsSelectUrl;
    }

    public void setCreditsSelectUrl(String creditsSelectUrl) {
        this.creditsSelectUrl = creditsSelectUrl;
    }


    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}
