package cn.com.duiba.enums.zhcreditslog;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;

import javax.annotation.CheckForNull;
import java.util.Map;

/**
 * 积分日志类型
 * Created by 歪大哥😁 on 2019-10-24.
 */
public enum LogTypeEnum {

    // 扣积分
    SUB_CREDITS(0, "0"),
    // 加积分
    ADD_CREDITS(100, "1"),
    // 积分回滚
    ROLL_BACK_CREDITS(200, "2"),
    ;

    private static final ImmutableMap<Integer, LogTypeEnum> ALL_MAPPING;

    static {
        Map<Integer, LogTypeEnum> temp = Maps.newHashMap();
        for (LogTypeEnum value : values()) {
            temp.put(value.type, value);
        }
        ALL_MAPPING = ImmutableMap.copyOf(temp);
    }

    @CheckForNull
    public static LogTypeEnum getByType(Integer type) {
        return ALL_MAPPING.get(type);
    }

    // 数据库定义类型值
    private int type;
    // 对方接口入参 对应值
    private String scoreTyp;

    public String getScoreTyp() {
        return scoreTyp;
    }

    public void setScoreTyp(String scoreTyp) {
        this.scoreTyp = scoreTyp;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    LogTypeEnum(int type, String scoreTyp) {
        this.type = type;
        this.scoreTyp = scoreTyp;
    }}
