package cn.com.duiba.mq;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

/**
 * Created by zzy on 2017/7/17.
 */
@Configuration
public class RocketMQTopicConstant {

    @Value("${notify.topic.crecord.requset}")
    private String crecordRequest;

    /**
     * 扣积分
     */
    @Value("${rocketmq.topic.3rdparty.subcredits}")
    private String subCredits;

    /**
     * 加积分
     */
    @Value("${rocketmq.topic.3rdparty.addcredits}")
    private String addCredits;

    /**
     * 结果通知
     */
    @Value("${rocketmq.topic.3rdparty.notifydeveloper}")
    private String notifyDeveloper;

    /**
     * 奖项标识符校验
     */
    @Value("${rocketmq.topic.3rdparty.validateprizemark}")
    private String validatePrizeTag;

    /**
     * 发邮件
     */
    @Value("${rocketmq.topic.3rdparty.sendemail}")
    private String sendEmail;

    /**
     * 发邮件
     */
    @Value("${rocketmq.topic.3rdparty.notifyQueue}")
    private String notifyQueue;

    /**
     * 发钉钉消息
     */
    @Value("${rocketmq.topic.3rdparty.sendDingMsg}")
    private String dingMessage;
    
    /**
     * 发送虚拟商品mq 消息
     */
    @Value("${rocketmq.topic.3rdparty.virtualExchange}")
    private String virtualExchange;


    /**
     * 发送延时mq 消息
     */
    @Value("${rocketmq.topic.3rdparty.delayMsg}")
    private String delayMsg;


    public String getSubCredits() {
        return subCredits;
    }

    public String getAddCredits() {
        return addCredits;
    }

    public String getCrecordRequest() {
        return crecordRequest;
    }

    public String getNotifyDeveloper() {
        return notifyDeveloper;
    }

    public String getValidatePrizeTag() {
        return validatePrizeTag;
    }

    public String getSendEmail() {
        return sendEmail;
    }

    public String getNotifyQueue() {
        return notifyQueue;
    }

    public String getDingMessage() {
        return dingMessage;
    }

	public String getVirtualExchange() {
		return virtualExchange;
	}

    public String getDelayMsg() {
        return delayMsg;
    }
}
