package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.order.center.api.dto.DevAbnormalOrderDto;
import cn.com.duiba.order.center.api.dto.OrderFasterViewDto;
import cn.com.duiba.order.center.api.paramquery.AmbnormalOrderQuery;
import cn.com.duiba.order.center.api.paramquery.OrdersWaitQuery;
import cn.com.duiba.order.center.api.paramquery.WaitAuditQuery;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by yansen on 17/3/29.
 */
@AdvancedFeignClient
public interface RemoteOrdersFasterReadService {
    /**
     *
     * @param appId
     * @param itemTitle
     * @param receiverTel
     * @param consumerId
     * @param orderNum
     * @param startDate
     * @param endDate
     * @param isDevOrder
     * @param isDuibaOrder
     * @return
     */
    public DubboResult<Long> findDevWaitOrderFastCount(Long appId, String itemTitle, String receiverTel, Long consumerId, String orderNum, Date
            startDate, Date endDate, String isDevOrder, String isDuibaOrder);

    DubboResult<Long> findVirtualAbnormalOrderCountByTime(Long appId, String orderNum, String supplierBizId, Long consumerId,
        Date timeout, Date startDate, Date endDate);

    /**
     *
     * @param paramMap
     * @return
     */
    DubboResult<Long> findAuditOrderFastCount(Map<String, Object> paramMap);

    /**
     *
     * @param appId
     * @return
     */
    DubboResult<Integer> getAuditOrdersCount(Long appId);

    /**
     *
     * @param appId
     * @return
     */
    DubboResult<Long> getWaitOrdersCount(Long appId) ;

    /**
     *
     * @param appId
     * @param startDay
     * @param endDay
     * @return
     */
    DubboResult<Integer> getProcessingOrdersCount(Long appId, Date startDay, Date endDay) ;

    /**
     * 已经冲载，不用map接受参数
     * @param paramMap
     * @return
     */
    @Deprecated
    DubboResult<List<OrderFasterViewDto>> findAuditOrderFast(Map<String,Object> paramMap);

    /**
     * 查询待审核的订单
     * @param query
     * @return
     */
    List<OrderFasterViewDto> selectAuditOrderFast(WaitAuditQuery query);

    /**
     * 查询待审核订单数量
     * @param query
     * @return
     */
    Long countAutditOrderFast(WaitAuditQuery query);

    /**
     *
     * @param ordersWaitQuery
     * @return
     */
    DubboResult<Map<String, Long>> getWaitRowAndMax(OrdersWaitQuery ordersWaitQuery);

    /**
     *
     * @param ordersWaitQuery
     * @return
     */
    DubboResult<List<Long>> findWaitExportOrderIds(OrdersWaitQuery ordersWaitQuery);

    /**
     *
     * @param ordersWaitQuery
     * @return
     */
    DubboResult<List<OrderFasterViewDto>> findDevWaitOrderFast(OrdersWaitQuery ordersWaitQuery);

    DubboResult<List<DevAbnormalOrderDto>> findVirtualAbnormalOrderByTime(Long appId, String orderNum, String supplierBizId,
        Long consumerId, Date timeout, Integer offset, Integer max, Date startDate, Date endDate);

    /**
     *
     * @param appId
     * @param orderNum
     * @return
     */
    DubboResult<List<OrderFasterViewDto>> findDevWaitOrderFastByOrderNum(Long appId, String orderNum);

    /**
     *
     * @param appId
     * @param delayTime
     * @return
     */
    DubboResult<Integer> getVirtualAbnormalOrdersCount(Long appId, Date delayTime);

    /**
     *
     * @param appId
     * @param orderNum
     * @param supplierBizId
     * @param consumerId
     * @param timeout
     * @return
     */
    public  DubboResult<Long> findVirtualAbnormalOrderCount(Long appId, String orderNum, String supplierBizId, Long consumerId, Date timeout);
    /**
     *
     * @param appId
     * @param orderNum
     * @param supplierBizId
     * @param consumerId
     * @param timeout
     * @param offset
     * @param max
     * @return
     */
    DubboResult<List<DevAbnormalOrderDto>> findVirtualAbnormalOrder(Long appId, String orderNum, String supplierBizId,
                                                       Long consumerId, Date timeout, Integer offset, Integer max);


    /**
     * 批量查询开发者
     * */
    List<OrderFasterViewDto> batchFindWaitOrdersByOrderNums(Long appId,List<String> orderNums);

    List<OrderFasterViewDto> selectAbnormalOrder(AmbnormalOrderQuery param);

    Integer countAbnormalOrder(AmbnormalOrderQuery param);
}
