package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.order.center.api.dto.OrdersDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;

/**
 * Created by yansen on 16/9/27.
 */
@AdvancedFeignClient
public interface RemoteOrdersTextChangeService {
    /**
     * 更新订单错误信息，状态，错误类型
     * @param orderId
     * @param consumerId
     * @param failType
     * @param errorMessage
     * @param error4Consumer
     * @param error4Develper
     * @param error4Admin
     * @return
     */
    public DubboResult<Integer> updateErrorMessageAndFailType(Long orderId, Long consumerId, Integer failType, String errorMessage,
                                                             String error4Consumer, String error4Develper, String error4Admin);

    /**
     * 更新最后发送时间
     * @param orderId
     * @param consumerId
     * @param lastSendTime
     * @return
     */
    public DubboResult<Integer> updateLastSendTime(Long orderId, Long consumerId, Date lastSendTime);

    /**
     * 更新开发者订单号
     * @param orderId
     * @param consumerId
     * @param developBizId
     * @return
     */
    public DubboResult<Integer> updateDevelopBizId(Long orderId,Long consumerId, String developBizId);

    /**
     * 更新上游订单
     * @param orderId
     * @param consumerId
     * @param supplierOrderId
     * @return
     */
    public DubboResult<Integer> updateSupplierOrderId(Long orderId,  Long consumerId, Long supplierOrderId);

    /**
     *
     * @param orderId
     * @param consumerId
     * @return
     */
    DubboResult<Integer> releaseCouponByOrderId(Long orderId, Long consumerId);

    /**
     * 下订单,更新优惠券ID, 兼容老版本
     * @deprecated  请使用 RemoteOrderItemService.updateCouponId
     * @param orderId
     * @param consumerId
     * @param couponId
     * @return
     */
    @Deprecated
    DubboResult<Integer> updateCouponId(Long orderId, Long consumerId, Long couponId);

    /**
     * @param orderId
     * @param consumerId
     * @param error4admin
     * @param error4developer
     * @param error4consumer
     * @return
     */
    DubboResult<Integer> updateErrorInfo(Long orderId, Long consumerId, String error4admin, String error4developer, String error4consumer);

    DubboResult<Integer> addExtraInfo(Long orderId, Long consumerId, String key, String value);


    Boolean updateOrderPayPrice(OrdersDto ordersDto);
}
