package cn.com.duiba.order.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.order.center.api.dto.OrdersExtraDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by yansen on 16/9/24.
 */
@AdvancedFeignClient
public interface RemoteOrdersExtraService {
    /**
     * 插入订单额外信息记录,只插入在线库
     * @param ordersExtra
     * @return
     */
    public DubboResult<OrdersExtraDto> insert(OrdersExtraDto ordersExtra);

    /**
     * 更新订单额外信息表的agent和transfer信息,只更新在线库
     * @param id
     * @param userAgent
     * @param transfer
     * @return
     */
    public DubboResult<Void> updateAgentAndTransfer(Long id, String userAgent, String transfer);
    /**
     * 查询订单扩展信息
     * @param orderId
     * @param orderType
     * @return
     */
    public DubboResult<OrdersExtraDto> findByOrderIdAndType(Long orderId, String orderType);

    /**
     * 根据订单id和来源查询订单扩展信息
     * @param orderId
     * @param orderType
     * @return
     */
    public OrdersExtraDto findOrdersExtraByOrderIdAndType(Long orderId,String orderType);
}
